package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCABuilder extends io.fabric8.openshift.api.model.operator.v1.ServiceCAFluentImpl<io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ServiceCA,io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder> {

    io.fabric8.openshift.api.model.operator.v1.ServiceCAFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServiceCABuilder() {
        this(true);
    }

    public ServiceCABuilder(java.lang.Boolean validationEnabled) {
        this(new ServiceCA(), validationEnabled);
    }

    public ServiceCABuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceCABuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServiceCA(), validationEnabled);
    }

    public ServiceCABuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ServiceCA instance) {
        this(fluent, instance, true);
    }

    public ServiceCABuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ServiceCA instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceCABuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCA instance) {
        this(instance,true);
    }

    public ServiceCABuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCA instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ServiceCA build() {
        ServiceCA buildable = new ServiceCA(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCABuilder that = (ServiceCABuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
