package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCAListBuilder extends io.fabric8.openshift.api.model.operator.v1.ServiceCAListFluentImpl<io.fabric8.openshift.api.model.operator.v1.ServiceCAListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ServiceCAList,io.fabric8.openshift.api.model.operator.v1.ServiceCAListBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ServiceCAListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServiceCAListBuilder() {
        this(true);
    }

    public ServiceCAListBuilder(java.lang.Boolean validationEnabled) {
        this(new ServiceCAList(), validationEnabled);
    }

    public ServiceCAListBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAListFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceCAListBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServiceCAList(), validationEnabled);
    }

    public ServiceCAListBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAListFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ServiceCAList instance) {
        this(fluent, instance, true);
    }

    public ServiceCAListBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAListFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ServiceCAList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceCAListBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAList instance) {
        this(instance,true);
    }

    public ServiceCAListBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ServiceCAList build() {
        ServiceCAList buildable = new ServiceCAList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCAListBuilder that = (ServiceCAListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
