package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCAStatusBuilder extends io.fabric8.openshift.api.model.operator.v1.ServiceCAStatusFluentImpl<io.fabric8.openshift.api.model.operator.v1.ServiceCAStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ServiceCAStatus,io.fabric8.openshift.api.model.operator.v1.ServiceCAStatusBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ServiceCAStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServiceCAStatusBuilder() {
        this(true);
    }

    public ServiceCAStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ServiceCAStatus(), validationEnabled);
    }

    public ServiceCAStatusBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceCAStatusBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServiceCAStatus(), validationEnabled);
    }

    public ServiceCAStatusBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ServiceCAStatus instance) {
        this(fluent, instance, true);
    }

    public ServiceCAStatusBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ServiceCAStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceCAStatusBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAStatus instance) {
        this(instance,true);
    }

    public ServiceCAStatusBuilder(io.fabric8.openshift.api.model.operator.v1.ServiceCAStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ServiceCAStatus build() {
        ServiceCAStatus buildable = new ServiceCAStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCAStatusBuilder that = (ServiceCAStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
