package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class CloudCredentialSpecBuilder extends io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpecFluentImpl<io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpec,io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpecBuilder>{
  public CloudCredentialSpecBuilder() {
    this(false);
  }
  public CloudCredentialSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new CloudCredentialSpec(), validationEnabled);
  }
  public CloudCredentialSpecBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CloudCredentialSpecBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CloudCredentialSpec(), validationEnabled);
  }
  public CloudCredentialSpecBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpec instance) {
    this(fluent, instance, false);
  }
  public CloudCredentialSpecBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentialsMode(instance.getCredentialsMode()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withManagementState(instance.getManagementState()); 
    fluent.withObservedConfig(instance.getObservedConfig()); 
    fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.validationEnabled = validationEnabled; 
  }
  public CloudCredentialSpecBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpec instance) {
    this(instance,false);
  }
  public CloudCredentialSpecBuilder(io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentialsMode(instance.getCredentialsMode()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.operator.v1.CloudCredentialSpec build() {
    CloudCredentialSpec buildable = new CloudCredentialSpec(fluent.getCredentialsMode(),fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CloudCredentialSpecBuilder that = (CloudCredentialSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}