package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class EndpointPublishingStrategyBuilder extends io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluentImpl<io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy,io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder>{
  public EndpointPublishingStrategyBuilder() {
    this(false);
  }
  public EndpointPublishingStrategyBuilder(java.lang.Boolean validationEnabled) {
    this(new EndpointPublishingStrategy(), validationEnabled);
  }
  public EndpointPublishingStrategyBuilder(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointPublishingStrategyBuilder(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointPublishingStrategy(), validationEnabled);
  }
  public EndpointPublishingStrategyBuilder(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy instance) {
    this(fluent, instance, false);
  }
  public EndpointPublishingStrategyBuilder(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHostNetwork(instance.getHostNetwork()); 
    fluent.withLoadBalancer(instance.getLoadBalancer()); 
    fluent.withNodePort(instance.getNodePort()); 
    fluent.withPrivate(instance.getPrivate()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public EndpointPublishingStrategyBuilder(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy instance) {
    this(instance,false);
  }
  public EndpointPublishingStrategyBuilder(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHostNetwork(instance.getHostNetwork()); 
    this.withLoadBalancer(instance.getLoadBalancer()); 
    this.withNodePort(instance.getNodePort()); 
    this.withPrivate(instance.getPrivate()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy build() {
    EndpointPublishingStrategy buildable = new EndpointPublishingStrategy(fluent.getHostNetwork(),fluent.getLoadBalancer(),fluent.getNodePort(),fluent.getPrivate(),fluent.getType());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointPublishingStrategyBuilder that = (EndpointPublishingStrategyBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}