package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceCatalogAPIServerSpecBuilder extends ServiceCatalogAPIServerSpecFluent<ServiceCatalogAPIServerSpecBuilder> implements VisitableBuilder<ServiceCatalogAPIServerSpec,ServiceCatalogAPIServerSpecBuilder>{
  public ServiceCatalogAPIServerSpecBuilder() {
    this(new ServiceCatalogAPIServerSpec());
  }
  
  public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent) {
    this(fluent, new ServiceCatalogAPIServerSpec());
  }
  
  public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent,ServiceCatalogAPIServerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceCatalogAPIServerSpecFluent<?> fluent;
  
  public ServiceCatalogAPIServerSpec build() {
    ServiceCatalogAPIServerSpec buildable = new ServiceCatalogAPIServerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}