package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigListBuilder extends ConfigListFluentImpl<ConfigListBuilder> implements VisitableBuilder<ConfigList,ConfigListBuilder>{
  public ConfigListBuilder() {
    this(false);
  }
  public ConfigListBuilder(Boolean validationEnabled) {
    this(new ConfigList(), validationEnabled);
  }
  public ConfigListBuilder(ConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigListBuilder(ConfigListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigList(), validationEnabled);
  }
  public ConfigListBuilder(ConfigListFluent<?> fluent,ConfigList instance) {
    this(fluent, instance, false);
  }
  public ConfigListBuilder(ConfigListFluent<?> fluent,ConfigList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigListBuilder(ConfigList instance) {
    this(instance,false);
  }
  public ConfigListBuilder(ConfigList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConfigListFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigList build() {
    ConfigList buildable = new ConfigList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}