package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConfigStatusFluentImpl<A extends ConfigStatusFluent<A>> extends BaseFluent<A> implements ConfigStatusFluent<A>{
  public ConfigStatusFluentImpl() {
  }
  public ConfigStatusFluentImpl(ConfigStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withGenerations(instance.getGenerations()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<OperatorConditionBuilder> conditions = new ArrayList<OperatorConditionBuilder>();
  private ArrayList<GenerationStatusBuilder> generations = new ArrayList<GenerationStatusBuilder>();
  private Long observedGeneration;
  private Integer readyReplicas;
  private String version;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<OperatorCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<OperatorCondition> items) {
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<OperatorConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      OperatorConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OperatorCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<OperatorCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public OperatorCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public OperatorCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public OperatorCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    for (OperatorConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    for (OperatorConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<OperatorCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (OperatorCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (OperatorCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  public ConfigStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ConfigStatusFluentImpl.ConditionsNestedImpl();
  }
  public ConfigStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
    return new ConfigStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ConfigStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,OperatorCondition item) {
    return new ConfigStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ConfigStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConfigStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ConfigStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConfigStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToGenerations(Integer index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(index >= 0 ? index : _visitables.get("generations").size(), builder);this.generations.add(index >= 0 ? index : generations.size(), builder); return (A)this;
  }
  public A setToGenerations(Integer index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("generations").size()) { _visitables.get("generations").add(builder); } else { _visitables.get("generations").set(index, builder);}
    if (index < 0 || index >= generations.size()) { generations.add(builder); } else { generations.set(index, builder);}
     return (A)this;
  }
  public A addToGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  public A addAllToGenerations(Collection<GenerationStatus> items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  public A removeFromGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items) {
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder);if (this.generations != null) {this.generations.remove(builder);}} return (A)this;
  }
  public A removeAllFromGenerations(Collection<GenerationStatus> items) {
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder);if (this.generations != null) {this.generations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate) {
    if (generations == null) return (A) this;
    final Iterator<GenerationStatusBuilder> each = generations.iterator();
    final List visitables = _visitables.get("generations");
    while (each.hasNext()) {
      GenerationStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGenerations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GenerationStatus> getGenerations() {
    return generations != null ? build(generations) : null;
  }
  public List<GenerationStatus> buildGenerations() {
    return generations != null ? build(generations) : null;
  }
  public GenerationStatus buildGeneration(Integer index) {
    return this.generations.get(index).build();
  }
  public GenerationStatus buildFirstGeneration() {
    return this.generations.get(0).build();
  }
  public GenerationStatus buildLastGeneration() {
    return this.generations.get(generations.size() - 1).build();
  }
  public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    for (GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    for (GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGenerations(List<GenerationStatus> generations) {
    if (this.generations != null) { _visitables.get("generations").removeAll(this.generations);}
    if (generations != null) {this.generations = new ArrayList(); for (GenerationStatus item : generations){this.addToGenerations(item);}} else { this.generations = null;} return (A) this;
  }
  public A withGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... generations) {
    if (this.generations != null) {this.generations.clear();}
    if (generations != null) {for (GenerationStatus item :generations){ this.addToGenerations(item);}} return (A) this;
  }
  public Boolean hasGenerations() {
    return generations != null && !generations.isEmpty();
  }
  public ConfigStatusFluent.GenerationsNested<A> addNewGeneration() {
    return new ConfigStatusFluentImpl.GenerationsNestedImpl();
  }
  public ConfigStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item) {
    return new ConfigStatusFluentImpl.GenerationsNestedImpl(-1, item);
  }
  public ConfigStatusFluent.GenerationsNested<A> setNewGenerationLike(Integer index,GenerationStatus item) {
    return new ConfigStatusFluentImpl.GenerationsNestedImpl(index, item);
  }
  public ConfigStatusFluent.GenerationsNested<A> editGeneration(Integer index) {
    if (generations.size() <= index) throw new RuntimeException("Can't edit generations. Index exceeds size.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public ConfigStatusFluent.GenerationsNested<A> editFirstGeneration() {
    if (generations.size() == 0) throw new RuntimeException("Can't edit first generations. The list is empty.");
    return setNewGenerationLike(0, buildGeneration(0));
  }
  public ConfigStatusFluent.GenerationsNested<A> editLastGeneration() {
    int index = generations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generations. The list is empty.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public ConfigStatusFluent.GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generations.size();i++) { 
    if (predicate.test(generations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generations. No match found.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public Integer getReadyReplicas() {
    return this.readyReplicas;
  }
  public A withReadyReplicas(Integer readyReplicas) {
    this.readyReplicas=readyReplicas; return (A) this;
  }
  public Boolean hasReadyReplicas() {
    return this.readyReplicas != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigStatusFluentImpl that = (ConfigStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (generations != null ? !generations.equals(that.generations) :that.generations != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (readyReplicas != null ? !readyReplicas.equals(that.readyReplicas) :that.readyReplicas != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  generations,  observedGeneration,  readyReplicas,  version,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (generations != null && !generations.isEmpty()) { sb.append("generations:"); sb.append(generations + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (readyReplicas != null) { sb.append("readyReplicas:"); sb.append(readyReplicas + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends OperatorConditionFluentImpl<ConfigStatusFluent.ConditionsNested<N>> implements ConfigStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,OperatorCondition item) {
      this.index = index;
      this.builder = new OperatorConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new OperatorConditionBuilder(this);
    }
    OperatorConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConfigStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class GenerationsNestedImpl<N> extends GenerationStatusFluentImpl<ConfigStatusFluent.GenerationsNested<N>> implements ConfigStatusFluent.GenerationsNested<N>,Nested<N>{
    GenerationsNestedImpl(Integer index,GenerationStatus item) {
      this.index = index;
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationsNestedImpl() {
      this.index = -1;
      this.builder = new GenerationStatusBuilder(this);
    }
    GenerationStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) ConfigStatusFluentImpl.this.setToGenerations(index,builder.build());
    }
    public N endGeneration() {
      return and();
    }
    
  }
  
}