package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPCompressionPolicyFluentImpl<A extends HTTPCompressionPolicyFluent<A>> extends BaseFluent<A> implements HTTPCompressionPolicyFluent<A>{
  public HTTPCompressionPolicyFluentImpl() {
  }
  public HTTPCompressionPolicyFluentImpl(HTTPCompressionPolicy instance) {
    this.withMimeTypes(instance.getMimeTypes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> mimeTypes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToMimeTypes(Integer index,String item) {
    if (this.mimeTypes == null) {this.mimeTypes = new ArrayList<String>();}
    this.mimeTypes.add(index, item);
    return (A)this;
  }
  public A setToMimeTypes(Integer index,String item) {
    if (this.mimeTypes == null) {this.mimeTypes = new ArrayList<String>();}
    this.mimeTypes.set(index, item); return (A)this;
  }
  public A addToMimeTypes(java.lang.String... items) {
    if (this.mimeTypes == null) {this.mimeTypes = new ArrayList<String>();}
    for (String item : items) {this.mimeTypes.add(item);} return (A)this;
  }
  public A addAllToMimeTypes(Collection<String> items) {
    if (this.mimeTypes == null) {this.mimeTypes = new ArrayList<String>();}
    for (String item : items) {this.mimeTypes.add(item);} return (A)this;
  }
  public A removeFromMimeTypes(java.lang.String... items) {
    for (String item : items) {if (this.mimeTypes!= null){ this.mimeTypes.remove(item);}} return (A)this;
  }
  public A removeAllFromMimeTypes(Collection<String> items) {
    for (String item : items) {if (this.mimeTypes!= null){ this.mimeTypes.remove(item);}} return (A)this;
  }
  public List<String> getMimeTypes() {
    return this.mimeTypes;
  }
  public String getMimeType(Integer index) {
    return this.mimeTypes.get(index);
  }
  public String getFirstMimeType() {
    return this.mimeTypes.get(0);
  }
  public String getLastMimeType() {
    return this.mimeTypes.get(mimeTypes.size() - 1);
  }
  public String getMatchingMimeType(Predicate<String> predicate) {
    for (String item: mimeTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingMimeType(Predicate<String> predicate) {
    for (String item: mimeTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMimeTypes(List<String> mimeTypes) {
    if (mimeTypes != null) {this.mimeTypes = new ArrayList(); for (String item : mimeTypes){this.addToMimeTypes(item);}} else { this.mimeTypes = null;} return (A) this;
  }
  public A withMimeTypes(java.lang.String... mimeTypes) {
    if (this.mimeTypes != null) {this.mimeTypes.clear();}
    if (mimeTypes != null) {for (String item :mimeTypes){ this.addToMimeTypes(item);}} return (A) this;
  }
  public Boolean hasMimeTypes() {
    return mimeTypes != null && !mimeTypes.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPCompressionPolicyFluentImpl that = (HTTPCompressionPolicyFluentImpl) o;
    if (mimeTypes != null ? !mimeTypes.equals(that.mimeTypes) :that.mimeTypes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(mimeTypes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mimeTypes != null && !mimeTypes.isEmpty()) { sb.append("mimeTypes:"); sb.append(mimeTypes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}