package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HybridOverlayConfigBuilder extends HybridOverlayConfigFluentImpl<HybridOverlayConfigBuilder> implements VisitableBuilder<HybridOverlayConfig,HybridOverlayConfigBuilder>{
  public HybridOverlayConfigBuilder() {
    this(false);
  }
  public HybridOverlayConfigBuilder(Boolean validationEnabled) {
    this(new HybridOverlayConfig(), validationEnabled);
  }
  public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HybridOverlayConfig(), validationEnabled);
  }
  public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent,HybridOverlayConfig instance) {
    this(fluent, instance, false);
  }
  public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent,HybridOverlayConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHybridClusterNetwork(instance.getHybridClusterNetwork()); 
    fluent.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HybridOverlayConfigBuilder(HybridOverlayConfig instance) {
    this(instance,false);
  }
  public HybridOverlayConfigBuilder(HybridOverlayConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHybridClusterNetwork(instance.getHybridClusterNetwork()); 
    this.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HybridOverlayConfigFluent<?> fluent;
  Boolean validationEnabled;
  public HybridOverlayConfig build() {
    HybridOverlayConfig buildable = new HybridOverlayConfig(fluent.getHybridClusterNetwork(),fluent.getHybridOverlayVXLANPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}