package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressControllerHTTPHeadersBuilder extends IngressControllerHTTPHeadersFluentImpl<IngressControllerHTTPHeadersBuilder> implements VisitableBuilder<IngressControllerHTTPHeaders,IngressControllerHTTPHeadersBuilder>{
  public IngressControllerHTTPHeadersBuilder() {
    this(false);
  }
  public IngressControllerHTTPHeadersBuilder(Boolean validationEnabled) {
    this(new IngressControllerHTTPHeaders(), validationEnabled);
  }
  public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeadersFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeadersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressControllerHTTPHeaders(), validationEnabled);
  }
  public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeadersFluent<?> fluent,IngressControllerHTTPHeaders instance) {
    this(fluent, instance, false);
  }
  public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeadersFluent<?> fluent,IngressControllerHTTPHeaders instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy()); 
    fluent.withHeaderNameCaseAdjustments(instance.getHeaderNameCaseAdjustments()); 
    fluent.withUniqueId(instance.getUniqueId()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeaders instance) {
    this(instance,false);
  }
  public IngressControllerHTTPHeadersBuilder(IngressControllerHTTPHeaders instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy()); 
    this.withHeaderNameCaseAdjustments(instance.getHeaderNameCaseAdjustments()); 
    this.withUniqueId(instance.getUniqueId()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressControllerHTTPHeadersFluent<?> fluent;
  Boolean validationEnabled;
  public IngressControllerHTTPHeaders build() {
    IngressControllerHTTPHeaders buildable = new IngressControllerHTTPHeaders(fluent.getForwardedHeaderPolicy(),fluent.getHeaderNameCaseAdjustments(),fluent.getUniqueId());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}