package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeControllerManagerStatusBuilder extends KubeControllerManagerStatusFluentImpl<KubeControllerManagerStatusBuilder> implements VisitableBuilder<KubeControllerManagerStatus,KubeControllerManagerStatusBuilder>{
  public KubeControllerManagerStatusBuilder() {
    this(false);
  }
  public KubeControllerManagerStatusBuilder(Boolean validationEnabled) {
    this(new KubeControllerManagerStatus(), validationEnabled);
  }
  public KubeControllerManagerStatusBuilder(KubeControllerManagerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeControllerManagerStatusBuilder(KubeControllerManagerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeControllerManagerStatus(), validationEnabled);
  }
  public KubeControllerManagerStatusBuilder(KubeControllerManagerStatusFluent<?> fluent,KubeControllerManagerStatus instance) {
    this(fluent, instance, false);
  }
  public KubeControllerManagerStatusBuilder(KubeControllerManagerStatusFluent<?> fluent,KubeControllerManagerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withGenerations(instance.getGenerations()); 
    fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
    fluent.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason()); 
    fluent.withNodeStatuses(instance.getNodeStatuses()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyReplicas(instance.getReadyReplicas()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubeControllerManagerStatusBuilder(KubeControllerManagerStatus instance) {
    this(instance,false);
  }
  public KubeControllerManagerStatusBuilder(KubeControllerManagerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withGenerations(instance.getGenerations()); 
    this.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
    this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason()); 
    this.withNodeStatuses(instance.getNodeStatuses()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KubeControllerManagerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KubeControllerManagerStatus build() {
    KubeControllerManagerStatus buildable = new KubeControllerManagerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getLatestAvailableRevision(),fluent.getLatestAvailableRevisionReason(),fluent.getNodeStatuses(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}