package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NodeStatusFluentImpl<A extends NodeStatusFluent<A>> extends BaseFluent<A> implements NodeStatusFluent<A>{
  public NodeStatusFluentImpl() {
  }
  public NodeStatusFluentImpl(NodeStatus instance) {
    this.withCurrentRevision(instance.getCurrentRevision()); 
    this.withLastFailedCount(instance.getLastFailedCount()); 
    this.withLastFailedReason(instance.getLastFailedReason()); 
    this.withLastFailedRevision(instance.getLastFailedRevision()); 
    this.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors()); 
    this.withLastFailedTime(instance.getLastFailedTime()); 
    this.withLastFallbackCount(instance.getLastFallbackCount()); 
    this.withNodeName(instance.getNodeName()); 
    this.withTargetRevision(instance.getTargetRevision()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer currentRevision;
  private Integer lastFailedCount;
  private String lastFailedReason;
  private Integer lastFailedRevision;
  private List<String> lastFailedRevisionErrors = new ArrayList<String>();
  private String lastFailedTime;
  private Integer lastFallbackCount;
  private String nodeName;
  private Integer targetRevision;
  private Map<String,Object> additionalProperties;
  public Integer getCurrentRevision() {
    return this.currentRevision;
  }
  public A withCurrentRevision(Integer currentRevision) {
    this.currentRevision=currentRevision; return (A) this;
  }
  public Boolean hasCurrentRevision() {
    return this.currentRevision != null;
  }
  public Integer getLastFailedCount() {
    return this.lastFailedCount;
  }
  public A withLastFailedCount(Integer lastFailedCount) {
    this.lastFailedCount=lastFailedCount; return (A) this;
  }
  public Boolean hasLastFailedCount() {
    return this.lastFailedCount != null;
  }
  public String getLastFailedReason() {
    return this.lastFailedReason;
  }
  public A withLastFailedReason(String lastFailedReason) {
    this.lastFailedReason=lastFailedReason; return (A) this;
  }
  public Boolean hasLastFailedReason() {
    return this.lastFailedReason != null;
  }
  public Integer getLastFailedRevision() {
    return this.lastFailedRevision;
  }
  public A withLastFailedRevision(Integer lastFailedRevision) {
    this.lastFailedRevision=lastFailedRevision; return (A) this;
  }
  public Boolean hasLastFailedRevision() {
    return this.lastFailedRevision != null;
  }
  public A addToLastFailedRevisionErrors(Integer index,String item) {
    if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new ArrayList<String>();}
    this.lastFailedRevisionErrors.add(index, item);
    return (A)this;
  }
  public A setToLastFailedRevisionErrors(Integer index,String item) {
    if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new ArrayList<String>();}
    this.lastFailedRevisionErrors.set(index, item); return (A)this;
  }
  public A addToLastFailedRevisionErrors(java.lang.String... items) {
    if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new ArrayList<String>();}
    for (String item : items) {this.lastFailedRevisionErrors.add(item);} return (A)this;
  }
  public A addAllToLastFailedRevisionErrors(Collection<String> items) {
    if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new ArrayList<String>();}
    for (String item : items) {this.lastFailedRevisionErrors.add(item);} return (A)this;
  }
  public A removeFromLastFailedRevisionErrors(java.lang.String... items) {
    for (String item : items) {if (this.lastFailedRevisionErrors!= null){ this.lastFailedRevisionErrors.remove(item);}} return (A)this;
  }
  public A removeAllFromLastFailedRevisionErrors(Collection<String> items) {
    for (String item : items) {if (this.lastFailedRevisionErrors!= null){ this.lastFailedRevisionErrors.remove(item);}} return (A)this;
  }
  public List<String> getLastFailedRevisionErrors() {
    return this.lastFailedRevisionErrors;
  }
  public String getLastFailedRevisionError(Integer index) {
    return this.lastFailedRevisionErrors.get(index);
  }
  public String getFirstLastFailedRevisionError() {
    return this.lastFailedRevisionErrors.get(0);
  }
  public String getLastLastFailedRevisionError() {
    return this.lastFailedRevisionErrors.get(lastFailedRevisionErrors.size() - 1);
  }
  public String getMatchingLastFailedRevisionError(Predicate<String> predicate) {
    for (String item: lastFailedRevisionErrors) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingLastFailedRevisionError(Predicate<String> predicate) {
    for (String item: lastFailedRevisionErrors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLastFailedRevisionErrors(List<String> lastFailedRevisionErrors) {
    if (lastFailedRevisionErrors != null) {this.lastFailedRevisionErrors = new ArrayList(); for (String item : lastFailedRevisionErrors){this.addToLastFailedRevisionErrors(item);}} else { this.lastFailedRevisionErrors = null;} return (A) this;
  }
  public A withLastFailedRevisionErrors(java.lang.String... lastFailedRevisionErrors) {
    if (this.lastFailedRevisionErrors != null) {this.lastFailedRevisionErrors.clear();}
    if (lastFailedRevisionErrors != null) {for (String item :lastFailedRevisionErrors){ this.addToLastFailedRevisionErrors(item);}} return (A) this;
  }
  public Boolean hasLastFailedRevisionErrors() {
    return lastFailedRevisionErrors != null && !lastFailedRevisionErrors.isEmpty();
  }
  public String getLastFailedTime() {
    return this.lastFailedTime;
  }
  public A withLastFailedTime(String lastFailedTime) {
    this.lastFailedTime=lastFailedTime; return (A) this;
  }
  public Boolean hasLastFailedTime() {
    return this.lastFailedTime != null;
  }
  public Integer getLastFallbackCount() {
    return this.lastFallbackCount;
  }
  public A withLastFallbackCount(Integer lastFallbackCount) {
    this.lastFallbackCount=lastFallbackCount; return (A) this;
  }
  public Boolean hasLastFallbackCount() {
    return this.lastFallbackCount != null;
  }
  public String getNodeName() {
    return this.nodeName;
  }
  public A withNodeName(String nodeName) {
    this.nodeName=nodeName; return (A) this;
  }
  public Boolean hasNodeName() {
    return this.nodeName != null;
  }
  public Integer getTargetRevision() {
    return this.targetRevision;
  }
  public A withTargetRevision(Integer targetRevision) {
    this.targetRevision=targetRevision; return (A) this;
  }
  public Boolean hasTargetRevision() {
    return this.targetRevision != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NodeStatusFluentImpl that = (NodeStatusFluentImpl) o;
    if (currentRevision != null ? !currentRevision.equals(that.currentRevision) :that.currentRevision != null) return false;
    if (lastFailedCount != null ? !lastFailedCount.equals(that.lastFailedCount) :that.lastFailedCount != null) return false;
    if (lastFailedReason != null ? !lastFailedReason.equals(that.lastFailedReason) :that.lastFailedReason != null) return false;
    if (lastFailedRevision != null ? !lastFailedRevision.equals(that.lastFailedRevision) :that.lastFailedRevision != null) return false;
    if (lastFailedRevisionErrors != null ? !lastFailedRevisionErrors.equals(that.lastFailedRevisionErrors) :that.lastFailedRevisionErrors != null) return false;
    if (lastFailedTime != null ? !lastFailedTime.equals(that.lastFailedTime) :that.lastFailedTime != null) return false;
    if (lastFallbackCount != null ? !lastFallbackCount.equals(that.lastFallbackCount) :that.lastFallbackCount != null) return false;
    if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
    if (targetRevision != null ? !targetRevision.equals(that.targetRevision) :that.targetRevision != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(currentRevision,  lastFailedCount,  lastFailedReason,  lastFailedRevision,  lastFailedRevisionErrors,  lastFailedTime,  lastFallbackCount,  nodeName,  targetRevision,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (currentRevision != null) { sb.append("currentRevision:"); sb.append(currentRevision + ","); }
    if (lastFailedCount != null) { sb.append("lastFailedCount:"); sb.append(lastFailedCount + ","); }
    if (lastFailedReason != null) { sb.append("lastFailedReason:"); sb.append(lastFailedReason + ","); }
    if (lastFailedRevision != null) { sb.append("lastFailedRevision:"); sb.append(lastFailedRevision + ","); }
    if (lastFailedRevisionErrors != null && !lastFailedRevisionErrors.isEmpty()) { sb.append("lastFailedRevisionErrors:"); sb.append(lastFailedRevisionErrors + ","); }
    if (lastFailedTime != null) { sb.append("lastFailedTime:"); sb.append(lastFailedTime + ","); }
    if (lastFallbackCount != null) { sb.append("lastFallbackCount:"); sb.append(lastFallbackCount + ","); }
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (targetRevision != null) { sb.append("targetRevision:"); sb.append(targetRevision + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}