package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface OpenShiftAPIServerFluent<A extends OpenShiftAPIServerFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public OpenShiftAPIServerFluent.MetadataNested<A> withNewMetadata();
  public OpenShiftAPIServerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public OpenShiftAPIServerFluent.MetadataNested<A> editMetadata();
  public OpenShiftAPIServerFluent.MetadataNested<A> editOrNewMetadata();
  public OpenShiftAPIServerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public OpenShiftAPIServerSpec getSpec();
  public OpenShiftAPIServerSpec buildSpec();
  public A withSpec(OpenShiftAPIServerSpec spec);
  public Boolean hasSpec();
  public OpenShiftAPIServerFluent.SpecNested<A> withNewSpec();
  public OpenShiftAPIServerFluent.SpecNested<A> withNewSpecLike(OpenShiftAPIServerSpec item);
  public OpenShiftAPIServerFluent.SpecNested<A> editSpec();
  public OpenShiftAPIServerFluent.SpecNested<A> editOrNewSpec();
  public OpenShiftAPIServerFluent.SpecNested<A> editOrNewSpecLike(OpenShiftAPIServerSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public OpenShiftAPIServerStatus getStatus();
  public OpenShiftAPIServerStatus buildStatus();
  public A withStatus(OpenShiftAPIServerStatus status);
  public Boolean hasStatus();
  public OpenShiftAPIServerFluent.StatusNested<A> withNewStatus();
  public OpenShiftAPIServerFluent.StatusNested<A> withNewStatusLike(OpenShiftAPIServerStatus item);
  public OpenShiftAPIServerFluent.StatusNested<A> editStatus();
  public OpenShiftAPIServerFluent.StatusNested<A> editOrNewStatus();
  public OpenShiftAPIServerFluent.StatusNested<A> editOrNewStatusLike(OpenShiftAPIServerStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<OpenShiftAPIServerFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,OpenShiftAPIServerSpecFluent<OpenShiftAPIServerFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,OpenShiftAPIServerStatusFluent<OpenShiftAPIServerFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}