package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AdditionalNetworkDefinitionBuilder extends AdditionalNetworkDefinitionFluentImpl<AdditionalNetworkDefinitionBuilder> implements VisitableBuilder<AdditionalNetworkDefinition,AdditionalNetworkDefinitionBuilder>{
  public AdditionalNetworkDefinitionBuilder() {
    this(false);
  }
  public AdditionalNetworkDefinitionBuilder(Boolean validationEnabled) {
    this(new AdditionalNetworkDefinition(), validationEnabled);
  }
  public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinitionFluent<?> fluent) {
    this(fluent, false);
  }
  public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinitionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AdditionalNetworkDefinition(), validationEnabled);
  }
  public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinitionFluent<?> fluent,AdditionalNetworkDefinition instance) {
    this(fluent, instance, false);
  }
  public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinitionFluent<?> fluent,AdditionalNetworkDefinition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withRawCNIConfig(instance.getRawCNIConfig()); 
    fluent.withSimpleMacvlanConfig(instance.getSimpleMacvlanConfig()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinition instance) {
    this(instance,false);
  }
  public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withRawCNIConfig(instance.getRawCNIConfig()); 
    this.withSimpleMacvlanConfig(instance.getSimpleMacvlanConfig()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AdditionalNetworkDefinitionFluent<?> fluent;
  Boolean validationEnabled;
  public AdditionalNetworkDefinition build() {
    AdditionalNetworkDefinition buildable = new AdditionalNetworkDefinition(fluent.getName(),fluent.getNamespace(),fluent.getRawCNIConfig(),fluent.getSimpleMacvlanConfig(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}