package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthenticationStatusBuilder extends AuthenticationStatusFluentImpl<AuthenticationStatusBuilder> implements VisitableBuilder<AuthenticationStatus,AuthenticationStatusBuilder>{
  public AuthenticationStatusBuilder() {
    this(false);
  }
  public AuthenticationStatusBuilder(Boolean validationEnabled) {
    this(new AuthenticationStatus(), validationEnabled);
  }
  public AuthenticationStatusBuilder(AuthenticationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationStatusBuilder(AuthenticationStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AuthenticationStatus(), validationEnabled);
  }
  public AuthenticationStatusBuilder(AuthenticationStatusFluent<?> fluent,AuthenticationStatus instance) {
    this(fluent, instance, false);
  }
  public AuthenticationStatusBuilder(AuthenticationStatusFluent<?> fluent,AuthenticationStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withGenerations(instance.getGenerations()); 
    fluent.withOauthAPIServer(instance.getOauthAPIServer()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyReplicas(instance.getReadyReplicas()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationStatusBuilder(AuthenticationStatus instance) {
    this(instance,false);
  }
  public AuthenticationStatusBuilder(AuthenticationStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withGenerations(instance.getGenerations()); 
    this.withOauthAPIServer(instance.getOauthAPIServer()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AuthenticationStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AuthenticationStatus build() {
    AuthenticationStatus buildable = new AuthenticationStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getOauthAPIServer(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}