package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPFIXConfigBuilder extends IPFIXConfigFluentImpl<IPFIXConfigBuilder> implements VisitableBuilder<IPFIXConfig,IPFIXConfigBuilder>{
  public IPFIXConfigBuilder() {
    this(false);
  }
  public IPFIXConfigBuilder(Boolean validationEnabled) {
    this(new IPFIXConfig(), validationEnabled);
  }
  public IPFIXConfigBuilder(IPFIXConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public IPFIXConfigBuilder(IPFIXConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IPFIXConfig(), validationEnabled);
  }
  public IPFIXConfigBuilder(IPFIXConfigFluent<?> fluent,IPFIXConfig instance) {
    this(fluent, instance, false);
  }
  public IPFIXConfigBuilder(IPFIXConfigFluent<?> fluent,IPFIXConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCollectors(instance.getCollectors()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IPFIXConfigBuilder(IPFIXConfig instance) {
    this(instance,false);
  }
  public IPFIXConfigBuilder(IPFIXConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCollectors(instance.getCollectors()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IPFIXConfigFluent<?> fluent;
  Boolean validationEnabled;
  public IPFIXConfig build() {
    IPFIXConfig buildable = new IPFIXConfig(fluent.getCollectors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}