package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyAuditConfigBuilder extends PolicyAuditConfigFluentImpl<PolicyAuditConfigBuilder> implements VisitableBuilder<PolicyAuditConfig,PolicyAuditConfigBuilder>{
  public PolicyAuditConfigBuilder() {
    this(false);
  }
  public PolicyAuditConfigBuilder(Boolean validationEnabled) {
    this(new PolicyAuditConfig(), validationEnabled);
  }
  public PolicyAuditConfigBuilder(PolicyAuditConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyAuditConfigBuilder(PolicyAuditConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PolicyAuditConfig(), validationEnabled);
  }
  public PolicyAuditConfigBuilder(PolicyAuditConfigFluent<?> fluent,PolicyAuditConfig instance) {
    this(fluent, instance, false);
  }
  public PolicyAuditConfigBuilder(PolicyAuditConfigFluent<?> fluent,PolicyAuditConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDestination(instance.getDestination()); 
    fluent.withMaxFileSize(instance.getMaxFileSize()); 
    fluent.withRateLimit(instance.getRateLimit()); 
    fluent.withSyslogFacility(instance.getSyslogFacility()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PolicyAuditConfigBuilder(PolicyAuditConfig instance) {
    this(instance,false);
  }
  public PolicyAuditConfigBuilder(PolicyAuditConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDestination(instance.getDestination()); 
    this.withMaxFileSize(instance.getMaxFileSize()); 
    this.withRateLimit(instance.getRateLimit()); 
    this.withSyslogFacility(instance.getSyslogFacility()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PolicyAuditConfigFluent<?> fluent;
  Boolean validationEnabled;
  public PolicyAuditConfig build() {
    PolicyAuditConfig buildable = new PolicyAuditConfig(fluent.getDestination(),fluent.getMaxFileSize(),fluent.getRateLimit(),fluent.getSyslogFacility());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}