package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProviderLoadBalancerParametersFluentImpl<A extends ProviderLoadBalancerParametersFluent<A>> extends BaseFluent<A> implements ProviderLoadBalancerParametersFluent<A>{
  public ProviderLoadBalancerParametersFluentImpl() {
  }
  public ProviderLoadBalancerParametersFluentImpl(ProviderLoadBalancerParameters instance) {
    this.withAws(instance.getAws()); 
    this.withGcp(instance.getGcp()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private AWSLoadBalancerParametersBuilder aws;
  private GCPLoadBalancerParametersBuilder gcp;
  private String type;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAws instead.
   * @return The buildable object.
   */
  @Deprecated
  public AWSLoadBalancerParameters getAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public AWSLoadBalancerParameters buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(AWSLoadBalancerParameters aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AWSLoadBalancerParametersBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  public Boolean hasAws() {
    return this.aws != null;
  }
  public ProviderLoadBalancerParametersFluent.AwsNested<A> withNewAws() {
    return new ProviderLoadBalancerParametersFluentImpl.AwsNestedImpl();
  }
  public ProviderLoadBalancerParametersFluent.AwsNested<A> withNewAwsLike(AWSLoadBalancerParameters item) {
    return new ProviderLoadBalancerParametersFluentImpl.AwsNestedImpl(item);
  }
  public ProviderLoadBalancerParametersFluent.AwsNested<A> editAws() {
    return withNewAwsLike(getAws());
  }
  public ProviderLoadBalancerParametersFluent.AwsNested<A> editOrNewAws() {
    return withNewAwsLike(getAws() != null ? getAws(): new AWSLoadBalancerParametersBuilder().build());
  }
  public ProviderLoadBalancerParametersFluent.AwsNested<A> editOrNewAwsLike(AWSLoadBalancerParameters item) {
    return withNewAwsLike(getAws() != null ? getAws(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGcp instead.
   * @return The buildable object.
   */
  @Deprecated
  public GCPLoadBalancerParameters getGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public GCPLoadBalancerParameters buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public A withGcp(GCPLoadBalancerParameters gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new GCPLoadBalancerParametersBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  public Boolean hasGcp() {
    return this.gcp != null;
  }
  public A withNewGcp(String clientAccess) {
    return (A)withGcp(new GCPLoadBalancerParameters(clientAccess));
  }
  public ProviderLoadBalancerParametersFluent.GcpNested<A> withNewGcp() {
    return new ProviderLoadBalancerParametersFluentImpl.GcpNestedImpl();
  }
  public ProviderLoadBalancerParametersFluent.GcpNested<A> withNewGcpLike(GCPLoadBalancerParameters item) {
    return new ProviderLoadBalancerParametersFluentImpl.GcpNestedImpl(item);
  }
  public ProviderLoadBalancerParametersFluent.GcpNested<A> editGcp() {
    return withNewGcpLike(getGcp());
  }
  public ProviderLoadBalancerParametersFluent.GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(getGcp() != null ? getGcp(): new GCPLoadBalancerParametersBuilder().build());
  }
  public ProviderLoadBalancerParametersFluent.GcpNested<A> editOrNewGcpLike(GCPLoadBalancerParameters item) {
    return withNewGcpLike(getGcp() != null ? getGcp(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProviderLoadBalancerParametersFluentImpl that = (ProviderLoadBalancerParametersFluentImpl) o;
    if (aws != null ? !aws.equals(that.aws) :that.aws != null) return false;
    if (gcp != null ? !gcp.equals(that.gcp) :that.gcp != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aws,  gcp,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AwsNestedImpl<N> extends AWSLoadBalancerParametersFluentImpl<ProviderLoadBalancerParametersFluent.AwsNested<N>> implements ProviderLoadBalancerParametersFluent.AwsNested<N>,Nested<N>{
    AwsNestedImpl(AWSLoadBalancerParameters item) {
      this.builder = new AWSLoadBalancerParametersBuilder(this, item);
    }
    AwsNestedImpl() {
      this.builder = new AWSLoadBalancerParametersBuilder(this);
    }
    AWSLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) ProviderLoadBalancerParametersFluentImpl.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  class GcpNestedImpl<N> extends GCPLoadBalancerParametersFluentImpl<ProviderLoadBalancerParametersFluent.GcpNested<N>> implements ProviderLoadBalancerParametersFluent.GcpNested<N>,Nested<N>{
    GcpNestedImpl(GCPLoadBalancerParameters item) {
      this.builder = new GCPLoadBalancerParametersBuilder(this, item);
    }
    GcpNestedImpl() {
      this.builder = new GCPLoadBalancerParametersBuilder(this);
    }
    GCPLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) ProviderLoadBalancerParametersFluentImpl.this.withGcp(builder.build());
    }
    public N endGcp() {
      return and();
    }
    
  }
  
}