package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServerFluentImpl<A extends ServerFluent<A>> extends BaseFluent<A> implements ServerFluent<A>{
  public ServerFluentImpl() {
  }
  public ServerFluentImpl(Server instance) {
    this.withForwardPlugin(instance.getForwardPlugin()); 
    this.withName(instance.getName()); 
    this.withZones(instance.getZones()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ForwardPluginBuilder forwardPlugin;
  private String name;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildForwardPlugin instead.
   * @return The buildable object.
   */
  @Deprecated
  public ForwardPlugin getForwardPlugin() {
    return this.forwardPlugin!=null ?this.forwardPlugin.build():null;
  }
  public ForwardPlugin buildForwardPlugin() {
    return this.forwardPlugin!=null ?this.forwardPlugin.build():null;
  }
  public A withForwardPlugin(ForwardPlugin forwardPlugin) {
    _visitables.get("forwardPlugin").remove(this.forwardPlugin);
    if (forwardPlugin!=null){ this.forwardPlugin= new ForwardPluginBuilder(forwardPlugin); _visitables.get("forwardPlugin").add(this.forwardPlugin);} else { this.forwardPlugin = null; _visitables.get("forwardPlugin").remove(this.forwardPlugin); } return (A) this;
  }
  public Boolean hasForwardPlugin() {
    return this.forwardPlugin != null;
  }
  public ServerFluent.ForwardPluginNested<A> withNewForwardPlugin() {
    return new ServerFluentImpl.ForwardPluginNestedImpl();
  }
  public ServerFluent.ForwardPluginNested<A> withNewForwardPluginLike(ForwardPlugin item) {
    return new ServerFluentImpl.ForwardPluginNestedImpl(item);
  }
  public ServerFluent.ForwardPluginNested<A> editForwardPlugin() {
    return withNewForwardPluginLike(getForwardPlugin());
  }
  public ServerFluent.ForwardPluginNested<A> editOrNewForwardPlugin() {
    return withNewForwardPluginLike(getForwardPlugin() != null ? getForwardPlugin(): new ForwardPluginBuilder().build());
  }
  public ServerFluent.ForwardPluginNested<A> editOrNewForwardPluginLike(ForwardPlugin item) {
    return withNewForwardPluginLike(getForwardPlugin() != null ? getForwardPlugin(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToZones(Integer index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  public A setToZones(Integer index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A removeFromZones(java.lang.String... items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public A removeAllFromZones(Collection<String> items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public List<String> getZones() {
    return this.zones;
  }
  public String getZone(Integer index) {
    return this.zones.get(index);
  }
  public String getFirstZone() {
    return this.zones.get(0);
  }
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  public String getMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withZones(List<String> zones) {
    if (zones != null) {this.zones = new ArrayList(); for (String item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
  }
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {this.zones.clear();}
    if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
  }
  public Boolean hasZones() {
    return zones != null && !zones.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerFluentImpl that = (ServerFluentImpl) o;
    if (forwardPlugin != null ? !forwardPlugin.equals(that.forwardPlugin) :that.forwardPlugin != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (zones != null ? !zones.equals(that.zones) :that.zones != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(forwardPlugin,  name,  zones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (forwardPlugin != null) { sb.append("forwardPlugin:"); sb.append(forwardPlugin + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ForwardPluginNestedImpl<N> extends ForwardPluginFluentImpl<ServerFluent.ForwardPluginNested<N>> implements ServerFluent.ForwardPluginNested<N>,Nested<N>{
    ForwardPluginNestedImpl(ForwardPlugin item) {
      this.builder = new ForwardPluginBuilder(this, item);
    }
    ForwardPluginNestedImpl() {
      this.builder = new ForwardPluginBuilder(this);
    }
    ForwardPluginBuilder builder;
    public N and() {
      return (N) ServerFluentImpl.this.withForwardPlugin(builder.build());
    }
    public N endForwardPlugin() {
      return and();
    }
    
  }
  
}