package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LogEntryBuilder extends LogEntryFluentImpl<LogEntryBuilder> implements VisitableBuilder<LogEntry,LogEntryBuilder>{
  public LogEntryBuilder() {
    this(false);
  }
  public LogEntryBuilder(Boolean validationEnabled) {
    this(new LogEntry(), validationEnabled);
  }
  public LogEntryBuilder(LogEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public LogEntryBuilder(LogEntryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LogEntry(), validationEnabled);
  }
  public LogEntryBuilder(LogEntryFluent<?> fluent,LogEntry instance) {
    this(fluent, instance, false);
  }
  public LogEntryBuilder(LogEntryFluent<?> fluent,LogEntry instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLatency(instance.getLatency()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withSuccess(instance.getSuccess()); 
    fluent.withTime(instance.getTime()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LogEntryBuilder(LogEntry instance) {
    this(instance,false);
  }
  public LogEntryBuilder(LogEntry instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLatency(instance.getLatency()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withSuccess(instance.getSuccess()); 
    this.withTime(instance.getTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  LogEntryFluent<?> fluent;
  Boolean validationEnabled;
  public LogEntry build() {
    LogEntry buildable = new LogEntry(fluent.getLatency(),fluent.getMessage(),fluent.getReason(),fluent.getSuccess(),fluent.getTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}