package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OutageEntryBuilder extends OutageEntryFluentImpl<OutageEntryBuilder> implements VisitableBuilder<OutageEntry,OutageEntryBuilder>{
  public OutageEntryBuilder() {
    this(false);
  }
  public OutageEntryBuilder(Boolean validationEnabled) {
    this(new OutageEntry(), validationEnabled);
  }
  public OutageEntryBuilder(OutageEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public OutageEntryBuilder(OutageEntryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OutageEntry(), validationEnabled);
  }
  public OutageEntryBuilder(OutageEntryFluent<?> fluent,OutageEntry instance) {
    this(fluent, instance, false);
  }
  public OutageEntryBuilder(OutageEntryFluent<?> fluent,OutageEntry instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEnd(instance.getEnd()); 
    fluent.withEndLogs(instance.getEndLogs()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withStart(instance.getStart()); 
    fluent.withStartLogs(instance.getStartLogs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OutageEntryBuilder(OutageEntry instance) {
    this(instance,false);
  }
  public OutageEntryBuilder(OutageEntry instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEnd(instance.getEnd()); 
    this.withEndLogs(instance.getEndLogs()); 
    this.withMessage(instance.getMessage()); 
    this.withStart(instance.getStart()); 
    this.withStartLogs(instance.getStartLogs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OutageEntryFluent<?> fluent;
  Boolean validationEnabled;
  public OutageEntry build() {
    OutageEntry buildable = new OutageEntry(fluent.getEnd(),fluent.getEndLogs(),fluent.getMessage(),fluent.getStart(),fluent.getStartLogs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}