package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterCSIDriverBuilder extends ClusterCSIDriverFluentImpl<ClusterCSIDriverBuilder> implements VisitableBuilder<ClusterCSIDriver,ClusterCSIDriverBuilder>{
  public ClusterCSIDriverBuilder() {
    this(false);
  }
  public ClusterCSIDriverBuilder(Boolean validationEnabled) {
    this(new ClusterCSIDriver(), validationEnabled);
  }
  public ClusterCSIDriverBuilder(ClusterCSIDriverFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterCSIDriverBuilder(ClusterCSIDriverFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterCSIDriver(), validationEnabled);
  }
  public ClusterCSIDriverBuilder(ClusterCSIDriverFluent<?> fluent,ClusterCSIDriver instance) {
    this(fluent, instance, false);
  }
  public ClusterCSIDriverBuilder(ClusterCSIDriverFluent<?> fluent,ClusterCSIDriver instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterCSIDriverBuilder(ClusterCSIDriver instance) {
    this(instance,false);
  }
  public ClusterCSIDriverBuilder(ClusterCSIDriver instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterCSIDriverFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterCSIDriver build() {
    ClusterCSIDriver buildable = new ClusterCSIDriver(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}