package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ForwardPluginFluentImpl<A extends ForwardPluginFluent<A>> extends BaseFluent<A> implements ForwardPluginFluent<A>{
  public ForwardPluginFluentImpl() {
  }
  public ForwardPluginFluentImpl(ForwardPlugin instance) {
    this.withPolicy(instance.getPolicy()); 
    this.withUpstreams(instance.getUpstreams()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String policy;
  private List<String> upstreams = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getPolicy() {
    return this.policy;
  }
  public A withPolicy(String policy) {
    this.policy=policy; return (A) this;
  }
  public Boolean hasPolicy() {
    return this.policy != null;
  }
  public A addToUpstreams(Integer index,String item) {
    if (this.upstreams == null) {this.upstreams = new ArrayList<String>();}
    this.upstreams.add(index, item);
    return (A)this;
  }
  public A setToUpstreams(Integer index,String item) {
    if (this.upstreams == null) {this.upstreams = new ArrayList<String>();}
    this.upstreams.set(index, item); return (A)this;
  }
  public A addToUpstreams(java.lang.String... items) {
    if (this.upstreams == null) {this.upstreams = new ArrayList<String>();}
    for (String item : items) {this.upstreams.add(item);} return (A)this;
  }
  public A addAllToUpstreams(Collection<String> items) {
    if (this.upstreams == null) {this.upstreams = new ArrayList<String>();}
    for (String item : items) {this.upstreams.add(item);} return (A)this;
  }
  public A removeFromUpstreams(java.lang.String... items) {
    for (String item : items) {if (this.upstreams!= null){ this.upstreams.remove(item);}} return (A)this;
  }
  public A removeAllFromUpstreams(Collection<String> items) {
    for (String item : items) {if (this.upstreams!= null){ this.upstreams.remove(item);}} return (A)this;
  }
  public List<String> getUpstreams() {
    return this.upstreams;
  }
  public String getUpstream(Integer index) {
    return this.upstreams.get(index);
  }
  public String getFirstUpstream() {
    return this.upstreams.get(0);
  }
  public String getLastUpstream() {
    return this.upstreams.get(upstreams.size() - 1);
  }
  public String getMatchingUpstream(Predicate<String> predicate) {
    for (String item: upstreams) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUpstream(Predicate<String> predicate) {
    for (String item: upstreams) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUpstreams(List<String> upstreams) {
    if (upstreams != null) {this.upstreams = new ArrayList(); for (String item : upstreams){this.addToUpstreams(item);}} else { this.upstreams = null;} return (A) this;
  }
  public A withUpstreams(java.lang.String... upstreams) {
    if (this.upstreams != null) {this.upstreams.clear();}
    if (upstreams != null) {for (String item :upstreams){ this.addToUpstreams(item);}} return (A) this;
  }
  public Boolean hasUpstreams() {
    return upstreams != null && !upstreams.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ForwardPluginFluentImpl that = (ForwardPluginFluentImpl) o;
    if (policy != null ? !policy.equals(that.policy) :that.policy != null) return false;
    if (upstreams != null ? !upstreams.equals(that.upstreams) :that.upstreams != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(policy,  upstreams,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (policy != null) { sb.append("policy:"); sb.append(policy + ","); }
    if (upstreams != null && !upstreams.isEmpty()) { sb.append("upstreams:"); sb.append(upstreams + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}