package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface KubeSchedulerStatusFluent<A extends KubeSchedulerStatusFluent<A>> extends Fluent<A>{
  public A addToConditions(Integer index,OperatorCondition item);
  public A setToConditions(Integer index,OperatorCondition item);
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items);
  public A addAllToConditions(Collection<OperatorCondition> items);
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items);
  public A removeAllFromConditions(Collection<OperatorCondition> items);
  public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OperatorCondition> getConditions();
  public List<OperatorCondition> buildConditions();
  public OperatorCondition buildCondition(Integer index);
  public OperatorCondition buildFirstCondition();
  public OperatorCondition buildLastCondition();
  public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
  public A withConditions(List<OperatorCondition> conditions);
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... conditions);
  public Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
  public KubeSchedulerStatusFluent.ConditionsNested<A> addNewCondition();
  public KubeSchedulerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
  public KubeSchedulerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,OperatorCondition item);
  public KubeSchedulerStatusFluent.ConditionsNested<A> editCondition(Integer index);
  public KubeSchedulerStatusFluent.ConditionsNested<A> editFirstCondition();
  public KubeSchedulerStatusFluent.ConditionsNested<A> editLastCondition();
  public KubeSchedulerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
  public A addToGenerations(Integer index,GenerationStatus item);
  public A setToGenerations(Integer index,GenerationStatus item);
  public A addToGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items);
  public A addAllToGenerations(Collection<GenerationStatus> items);
  public A removeFromGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items);
  public A removeAllFromGenerations(Collection<GenerationStatus> items);
  public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildGenerations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GenerationStatus> getGenerations();
  public List<GenerationStatus> buildGenerations();
  public GenerationStatus buildGeneration(Integer index);
  public GenerationStatus buildFirstGeneration();
  public GenerationStatus buildLastGeneration();
  public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
  public Boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
  public A withGenerations(List<GenerationStatus> generations);
  public A withGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... generations);
  public Boolean hasGenerations();
  public KubeSchedulerStatusFluent.GenerationsNested<A> addNewGeneration();
  public KubeSchedulerStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item);
  public KubeSchedulerStatusFluent.GenerationsNested<A> setNewGenerationLike(Integer index,GenerationStatus item);
  public KubeSchedulerStatusFluent.GenerationsNested<A> editGeneration(Integer index);
  public KubeSchedulerStatusFluent.GenerationsNested<A> editFirstGeneration();
  public KubeSchedulerStatusFluent.GenerationsNested<A> editLastGeneration();
  public KubeSchedulerStatusFluent.GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
  public Integer getLatestAvailableRevision();
  public A withLatestAvailableRevision(Integer latestAvailableRevision);
  public Boolean hasLatestAvailableRevision();
  public String getLatestAvailableRevisionReason();
  public A withLatestAvailableRevisionReason(String latestAvailableRevisionReason);
  public Boolean hasLatestAvailableRevisionReason();
  public A addToNodeStatuses(Integer index,NodeStatus item);
  public A setToNodeStatuses(Integer index,NodeStatus item);
  public A addToNodeStatuses(io.fabric8.openshift.api.model.operator.v1.NodeStatus... items);
  public A addAllToNodeStatuses(Collection<NodeStatus> items);
  public A removeFromNodeStatuses(io.fabric8.openshift.api.model.operator.v1.NodeStatus... items);
  public A removeAllFromNodeStatuses(Collection<NodeStatus> items);
  public A removeMatchingFromNodeStatuses(Predicate<NodeStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildNodeStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NodeStatus> getNodeStatuses();
  public List<NodeStatus> buildNodeStatuses();
  public NodeStatus buildNodeStatus(Integer index);
  public NodeStatus buildFirstNodeStatus();
  public NodeStatus buildLastNodeStatus();
  public NodeStatus buildMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate);
  public Boolean hasMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate);
  public A withNodeStatuses(List<NodeStatus> nodeStatuses);
  public A withNodeStatuses(io.fabric8.openshift.api.model.operator.v1.NodeStatus... nodeStatuses);
  public Boolean hasNodeStatuses();
  public KubeSchedulerStatusFluent.NodeStatusesNested<A> addNewNodeStatus();
  public KubeSchedulerStatusFluent.NodeStatusesNested<A> addNewNodeStatusLike(NodeStatus item);
  public KubeSchedulerStatusFluent.NodeStatusesNested<A> setNewNodeStatusLike(Integer index,NodeStatus item);
  public KubeSchedulerStatusFluent.NodeStatusesNested<A> editNodeStatus(Integer index);
  public KubeSchedulerStatusFluent.NodeStatusesNested<A> editFirstNodeStatus();
  public KubeSchedulerStatusFluent.NodeStatusesNested<A> editLastNodeStatus();
  public KubeSchedulerStatusFluent.NodeStatusesNested<A> editMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate);
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public Integer getReadyReplicas();
  public A withReadyReplicas(Integer readyReplicas);
  public Boolean hasReadyReplicas();
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,OperatorConditionFluent<KubeSchedulerStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface GenerationsNested<N> extends Nested<N>,GenerationStatusFluent<KubeSchedulerStatusFluent.GenerationsNested<N>>{
    public N and();
    public N endGeneration();
    
  }
  public interface NodeStatusesNested<N> extends Nested<N>,NodeStatusFluent<KubeSchedulerStatusFluent.NodeStatusesNested<N>>{
    public N and();
    public N endNodeStatus();
    
  }
  
}