package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProviderLoadBalancerParametersBuilder extends ProviderLoadBalancerParametersFluentImpl<ProviderLoadBalancerParametersBuilder> implements VisitableBuilder<ProviderLoadBalancerParameters,ProviderLoadBalancerParametersBuilder>{
  public ProviderLoadBalancerParametersBuilder() {
    this(false);
  }
  public ProviderLoadBalancerParametersBuilder(Boolean validationEnabled) {
    this(new ProviderLoadBalancerParameters(), validationEnabled);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProviderLoadBalancerParameters(), validationEnabled);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent,ProviderLoadBalancerParameters instance) {
    this(fluent, instance, false);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent,ProviderLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAws(instance.getAws()); 
    fluent.withGcp(instance.getGcp()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParameters instance) {
    this(instance,false);
  }
  public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAws(instance.getAws()); 
    this.withGcp(instance.getGcp()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ProviderLoadBalancerParametersFluent<?> fluent;
  Boolean validationEnabled;
  public ProviderLoadBalancerParameters build() {
    ProviderLoadBalancerParameters buildable = new ProviderLoadBalancerParameters(fluent.getAws(),fluent.getGcp(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}