package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SFlowConfigBuilder extends SFlowConfigFluentImpl<SFlowConfigBuilder> implements VisitableBuilder<SFlowConfig,SFlowConfigBuilder>{
  public SFlowConfigBuilder() {
    this(false);
  }
  public SFlowConfigBuilder(Boolean validationEnabled) {
    this(new SFlowConfig(), validationEnabled);
  }
  public SFlowConfigBuilder(SFlowConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public SFlowConfigBuilder(SFlowConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SFlowConfig(), validationEnabled);
  }
  public SFlowConfigBuilder(SFlowConfigFluent<?> fluent,SFlowConfig instance) {
    this(fluent, instance, false);
  }
  public SFlowConfigBuilder(SFlowConfigFluent<?> fluent,SFlowConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCollectors(instance.getCollectors()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SFlowConfigBuilder(SFlowConfig instance) {
    this(instance,false);
  }
  public SFlowConfigBuilder(SFlowConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCollectors(instance.getCollectors()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SFlowConfigFluent<?> fluent;
  Boolean validationEnabled;
  public SFlowConfig build() {
    SFlowConfig buildable = new SFlowConfig(fluent.getCollectors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}