package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCABuilder extends ServiceCAFluentImpl<ServiceCABuilder> implements VisitableBuilder<ServiceCA,ServiceCABuilder>{
  public ServiceCABuilder() {
    this(false);
  }
  public ServiceCABuilder(Boolean validationEnabled) {
    this(new ServiceCA(), validationEnabled);
  }
  public ServiceCABuilder(ServiceCAFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCABuilder(ServiceCAFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCA(), validationEnabled);
  }
  public ServiceCABuilder(ServiceCAFluent<?> fluent,ServiceCA instance) {
    this(fluent, instance, false);
  }
  public ServiceCABuilder(ServiceCAFluent<?> fluent,ServiceCA instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceCABuilder(ServiceCA instance) {
    this(instance,false);
  }
  public ServiceCABuilder(ServiceCA instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceCAFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCA build() {
    ServiceCA buildable = new ServiceCA(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}