package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StaticIPAMAddressesBuilder extends StaticIPAMAddressesFluentImpl<StaticIPAMAddressesBuilder> implements VisitableBuilder<StaticIPAMAddresses,StaticIPAMAddressesBuilder>{
  public StaticIPAMAddressesBuilder() {
    this(false);
  }
  public StaticIPAMAddressesBuilder(Boolean validationEnabled) {
    this(new StaticIPAMAddresses(), validationEnabled);
  }
  public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent) {
    this(fluent, false);
  }
  public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StaticIPAMAddresses(), validationEnabled);
  }
  public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent,StaticIPAMAddresses instance) {
    this(fluent, instance, false);
  }
  public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent,StaticIPAMAddresses instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withGateway(instance.getGateway()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StaticIPAMAddressesBuilder(StaticIPAMAddresses instance) {
    this(instance,false);
  }
  public StaticIPAMAddressesBuilder(StaticIPAMAddresses instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withGateway(instance.getGateway()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StaticIPAMAddressesFluent<?> fluent;
  Boolean validationEnabled;
  public StaticIPAMAddresses build() {
    StaticIPAMAddresses buildable = new StaticIPAMAddresses(fluent.getAddress(),fluent.getGateway());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}