package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodNetworkConnectivityCheckSpecBuilder extends PodNetworkConnectivityCheckSpecFluent<PodNetworkConnectivityCheckSpecBuilder> implements VisitableBuilder<PodNetworkConnectivityCheckSpec,PodNetworkConnectivityCheckSpecBuilder>{
  public PodNetworkConnectivityCheckSpecBuilder() {
    this(false);
  }
  public PodNetworkConnectivityCheckSpecBuilder(Boolean validationEnabled) {
    this(new PodNetworkConnectivityCheckSpec(), validationEnabled);
  }
  public PodNetworkConnectivityCheckSpecBuilder(PodNetworkConnectivityCheckSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodNetworkConnectivityCheckSpecBuilder(PodNetworkConnectivityCheckSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodNetworkConnectivityCheckSpec(), validationEnabled);
  }
  public PodNetworkConnectivityCheckSpecBuilder(PodNetworkConnectivityCheckSpecFluent<?> fluent,PodNetworkConnectivityCheckSpec instance) {
    this(fluent, instance, false);
  }
  public PodNetworkConnectivityCheckSpecBuilder(PodNetworkConnectivityCheckSpecFluent<?> fluent,PodNetworkConnectivityCheckSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodNetworkConnectivityCheckSpec());

    if (instance != null) {
      fluent.withSourcePod(instance.getSourcePod());
      fluent.withTargetEndpoint(instance.getTargetEndpoint());
      fluent.withTlsClientCert(instance.getTlsClientCert());
      fluent.withSourcePod(instance.getSourcePod());
      fluent.withTargetEndpoint(instance.getTargetEndpoint());
      fluent.withTlsClientCert(instance.getTlsClientCert());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodNetworkConnectivityCheckSpecBuilder(PodNetworkConnectivityCheckSpec instance) {
    this(instance,false);
  }
  public PodNetworkConnectivityCheckSpecBuilder(PodNetworkConnectivityCheckSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodNetworkConnectivityCheckSpec());

    if (instance != null) {
      this.withSourcePod(instance.getSourcePod());
      this.withTargetEndpoint(instance.getTargetEndpoint());
      this.withTlsClientCert(instance.getTlsClientCert());
      this.withSourcePod(instance.getSourcePod());
      this.withTargetEndpoint(instance.getTargetEndpoint());
      this.withTlsClientCert(instance.getTlsClientCert());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodNetworkConnectivityCheckSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodNetworkConnectivityCheckSpec build() {
    PodNetworkConnectivityCheckSpec buildable = new PodNetworkConnectivityCheckSpec(fluent.getSourcePod(),fluent.getTargetEndpoint(),fluent.getTlsClientCert());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}