package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSCSIDriverConfigSpecBuilder extends AWSCSIDriverConfigSpecFluent<AWSCSIDriverConfigSpecBuilder> implements VisitableBuilder<AWSCSIDriverConfigSpec,AWSCSIDriverConfigSpecBuilder>{
  public AWSCSIDriverConfigSpecBuilder() {
    this(false);
  }
  public AWSCSIDriverConfigSpecBuilder(Boolean validationEnabled) {
    this(new AWSCSIDriverConfigSpec(), validationEnabled);
  }
  public AWSCSIDriverConfigSpecBuilder(AWSCSIDriverConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSCSIDriverConfigSpecBuilder(AWSCSIDriverConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSCSIDriverConfigSpec(), validationEnabled);
  }
  public AWSCSIDriverConfigSpecBuilder(AWSCSIDriverConfigSpecFluent<?> fluent,AWSCSIDriverConfigSpec instance) {
    this(fluent, instance, false);
  }
  public AWSCSIDriverConfigSpecBuilder(AWSCSIDriverConfigSpecFluent<?> fluent,AWSCSIDriverConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSCSIDriverConfigSpec());

    if (instance != null) {
      fluent.withKmsKeyARN(instance.getKmsKeyARN());
      fluent.withKmsKeyARN(instance.getKmsKeyARN());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSCSIDriverConfigSpecBuilder(AWSCSIDriverConfigSpec instance) {
    this(instance,false);
  }
  public AWSCSIDriverConfigSpecBuilder(AWSCSIDriverConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSCSIDriverConfigSpec());

    if (instance != null) {
      this.withKmsKeyARN(instance.getKmsKeyARN());
      this.withKmsKeyARN(instance.getKmsKeyARN());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSCSIDriverConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AWSCSIDriverConfigSpec build() {
    AWSCSIDriverConfigSpec buildable = new AWSCSIDriverConfigSpec(fluent.getKmsKeyARN());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}