package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthenticationListBuilder extends AuthenticationListFluent<AuthenticationListBuilder> implements VisitableBuilder<AuthenticationList,AuthenticationListBuilder>{
  public AuthenticationListBuilder() {
    this(false);
  }
  public AuthenticationListBuilder(Boolean validationEnabled) {
    this(new AuthenticationList(), validationEnabled);
  }
  public AuthenticationListBuilder(AuthenticationListFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationListBuilder(AuthenticationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AuthenticationList(), validationEnabled);
  }
  public AuthenticationListBuilder(AuthenticationListFluent<?> fluent,AuthenticationList instance) {
    this(fluent, instance, false);
  }
  public AuthenticationListBuilder(AuthenticationListFluent<?> fluent,AuthenticationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AuthenticationList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationListBuilder(AuthenticationList instance) {
    this(instance,false);
  }
  public AuthenticationListBuilder(AuthenticationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AuthenticationList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AuthenticationListFluent<?> fluent;
  Boolean validationEnabled;
  public AuthenticationList build() {
    AuthenticationList buildable = new AuthenticationList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}