package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureCSIDriverConfigSpecBuilder extends AzureCSIDriverConfigSpecFluent<AzureCSIDriverConfigSpecBuilder> implements VisitableBuilder<AzureCSIDriverConfigSpec,AzureCSIDriverConfigSpecBuilder>{
  public AzureCSIDriverConfigSpecBuilder() {
    this(false);
  }
  public AzureCSIDriverConfigSpecBuilder(Boolean validationEnabled) {
    this(new AzureCSIDriverConfigSpec(), validationEnabled);
  }
  public AzureCSIDriverConfigSpecBuilder(AzureCSIDriverConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureCSIDriverConfigSpecBuilder(AzureCSIDriverConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzureCSIDriverConfigSpec(), validationEnabled);
  }
  public AzureCSIDriverConfigSpecBuilder(AzureCSIDriverConfigSpecFluent<?> fluent,AzureCSIDriverConfigSpec instance) {
    this(fluent, instance, false);
  }
  public AzureCSIDriverConfigSpecBuilder(AzureCSIDriverConfigSpecFluent<?> fluent,AzureCSIDriverConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AzureCSIDriverConfigSpec());

    if (instance != null) {
      fluent.withDiskEncryptionSet(instance.getDiskEncryptionSet());
      fluent.withDiskEncryptionSet(instance.getDiskEncryptionSet());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzureCSIDriverConfigSpecBuilder(AzureCSIDriverConfigSpec instance) {
    this(instance,false);
  }
  public AzureCSIDriverConfigSpecBuilder(AzureCSIDriverConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AzureCSIDriverConfigSpec());

    if (instance != null) {
      this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
      this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzureCSIDriverConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AzureCSIDriverConfigSpec build() {
    AzureCSIDriverConfigSpec buildable = new AzureCSIDriverConfigSpec(fluent.buildDiskEncryptionSet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}