package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureDiskEncryptionSetBuilder extends AzureDiskEncryptionSetFluent<AzureDiskEncryptionSetBuilder> implements VisitableBuilder<AzureDiskEncryptionSet,AzureDiskEncryptionSetBuilder>{
  public AzureDiskEncryptionSetBuilder() {
    this(false);
  }
  public AzureDiskEncryptionSetBuilder(Boolean validationEnabled) {
    this(new AzureDiskEncryptionSet(), validationEnabled);
  }
  public AzureDiskEncryptionSetBuilder(AzureDiskEncryptionSetFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureDiskEncryptionSetBuilder(AzureDiskEncryptionSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzureDiskEncryptionSet(), validationEnabled);
  }
  public AzureDiskEncryptionSetBuilder(AzureDiskEncryptionSetFluent<?> fluent,AzureDiskEncryptionSet instance) {
    this(fluent, instance, false);
  }
  public AzureDiskEncryptionSetBuilder(AzureDiskEncryptionSetFluent<?> fluent,AzureDiskEncryptionSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AzureDiskEncryptionSet());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withResourceGroup(instance.getResourceGroup());
      fluent.withSubscriptionID(instance.getSubscriptionID());
      fluent.withName(instance.getName());
      fluent.withResourceGroup(instance.getResourceGroup());
      fluent.withSubscriptionID(instance.getSubscriptionID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzureDiskEncryptionSetBuilder(AzureDiskEncryptionSet instance) {
    this(instance,false);
  }
  public AzureDiskEncryptionSetBuilder(AzureDiskEncryptionSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AzureDiskEncryptionSet());

    if (instance != null) {
      this.withName(instance.getName());
      this.withResourceGroup(instance.getResourceGroup());
      this.withSubscriptionID(instance.getSubscriptionID());
      this.withName(instance.getName());
      this.withResourceGroup(instance.getResourceGroup());
      this.withSubscriptionID(instance.getSubscriptionID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzureDiskEncryptionSetFluent<?> fluent;
  Boolean validationEnabled;
  public AzureDiskEncryptionSet build() {
    AzureDiskEncryptionSet buildable = new AzureDiskEncryptionSet(fluent.getName(),fluent.getResourceGroup(),fluent.getSubscriptionID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}