package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSISnapshotControllerBuilder extends CSISnapshotControllerFluent<CSISnapshotControllerBuilder> implements VisitableBuilder<CSISnapshotController,CSISnapshotControllerBuilder>{
  public CSISnapshotControllerBuilder() {
    this(false);
  }
  public CSISnapshotControllerBuilder(Boolean validationEnabled) {
    this(new CSISnapshotController(), validationEnabled);
  }
  public CSISnapshotControllerBuilder(CSISnapshotControllerFluent<?> fluent) {
    this(fluent, false);
  }
  public CSISnapshotControllerBuilder(CSISnapshotControllerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSISnapshotController(), validationEnabled);
  }
  public CSISnapshotControllerBuilder(CSISnapshotControllerFluent<?> fluent,CSISnapshotController instance) {
    this(fluent, instance, false);
  }
  public CSISnapshotControllerBuilder(CSISnapshotControllerFluent<?> fluent,CSISnapshotController instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CSISnapshotController());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CSISnapshotControllerBuilder(CSISnapshotController instance) {
    this(instance,false);
  }
  public CSISnapshotControllerBuilder(CSISnapshotController instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CSISnapshotController());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CSISnapshotControllerFluent<?> fluent;
  Boolean validationEnabled;
  public CSISnapshotController build() {
    CSISnapshotController buildable = new CSISnapshotController(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}