package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSISnapshotControllerStatusBuilder extends CSISnapshotControllerStatusFluent<CSISnapshotControllerStatusBuilder> implements VisitableBuilder<CSISnapshotControllerStatus,CSISnapshotControllerStatusBuilder>{
  public CSISnapshotControllerStatusBuilder() {
    this(false);
  }
  public CSISnapshotControllerStatusBuilder(Boolean validationEnabled) {
    this(new CSISnapshotControllerStatus(), validationEnabled);
  }
  public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSISnapshotControllerStatus(), validationEnabled);
  }
  public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatusFluent<?> fluent,CSISnapshotControllerStatus instance) {
    this(fluent, instance, false);
  }
  public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatusFluent<?> fluent,CSISnapshotControllerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CSISnapshotControllerStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatus instance) {
    this(instance,false);
  }
  public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CSISnapshotControllerStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CSISnapshotControllerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CSISnapshotControllerStatus build() {
    CSISnapshotControllerStatus buildable = new CSISnapshotControllerStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}