package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CloudCredentialStatusBuilder extends CloudCredentialStatusFluent<CloudCredentialStatusBuilder> implements VisitableBuilder<CloudCredentialStatus,CloudCredentialStatusBuilder>{
  public CloudCredentialStatusBuilder() {
    this(false);
  }
  public CloudCredentialStatusBuilder(Boolean validationEnabled) {
    this(new CloudCredentialStatus(), validationEnabled);
  }
  public CloudCredentialStatusBuilder(CloudCredentialStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CloudCredentialStatusBuilder(CloudCredentialStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CloudCredentialStatus(), validationEnabled);
  }
  public CloudCredentialStatusBuilder(CloudCredentialStatusFluent<?> fluent,CloudCredentialStatus instance) {
    this(fluent, instance, false);
  }
  public CloudCredentialStatusBuilder(CloudCredentialStatusFluent<?> fluent,CloudCredentialStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CloudCredentialStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CloudCredentialStatusBuilder(CloudCredentialStatus instance) {
    this(instance,false);
  }
  public CloudCredentialStatusBuilder(CloudCredentialStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CloudCredentialStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CloudCredentialStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CloudCredentialStatus build() {
    CloudCredentialStatus buildable = new CloudCredentialStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}