package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleConfigRouteBuilder extends ConsoleConfigRouteFluent<ConsoleConfigRouteBuilder> implements VisitableBuilder<ConsoleConfigRoute,ConsoleConfigRouteBuilder>{
  public ConsoleConfigRouteBuilder() {
    this(false);
  }
  public ConsoleConfigRouteBuilder(Boolean validationEnabled) {
    this(new ConsoleConfigRoute(), validationEnabled);
  }
  public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleConfigRoute(), validationEnabled);
  }
  public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent,ConsoleConfigRoute instance) {
    this(fluent, instance, false);
  }
  public ConsoleConfigRouteBuilder(ConsoleConfigRouteFluent<?> fluent,ConsoleConfigRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsoleConfigRoute());

    if (instance != null) {
      fluent.withHostname(instance.getHostname());
      fluent.withSecret(instance.getSecret());
      fluent.withHostname(instance.getHostname());
      fluent.withSecret(instance.getSecret());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleConfigRouteBuilder(ConsoleConfigRoute instance) {
    this(instance,false);
  }
  public ConsoleConfigRouteBuilder(ConsoleConfigRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsoleConfigRoute());

    if (instance != null) {
      this.withHostname(instance.getHostname());
      this.withSecret(instance.getSecret());
      this.withHostname(instance.getHostname());
      this.withSecret(instance.getSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleConfigRouteFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleConfigRoute build() {
    ConsoleConfigRoute buildable = new ConsoleConfigRoute(fluent.getHostname(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}