package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleCustomizationBuilder extends ConsoleCustomizationFluent<ConsoleCustomizationBuilder> implements VisitableBuilder<ConsoleCustomization,ConsoleCustomizationBuilder>{
  public ConsoleCustomizationBuilder() {
    this(false);
  }
  public ConsoleCustomizationBuilder(Boolean validationEnabled) {
    this(new ConsoleCustomization(), validationEnabled);
  }
  public ConsoleCustomizationBuilder(ConsoleCustomizationFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleCustomizationBuilder(ConsoleCustomizationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleCustomization(), validationEnabled);
  }
  public ConsoleCustomizationBuilder(ConsoleCustomizationFluent<?> fluent,ConsoleCustomization instance) {
    this(fluent, instance, false);
  }
  public ConsoleCustomizationBuilder(ConsoleCustomizationFluent<?> fluent,ConsoleCustomization instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsoleCustomization());

    if (instance != null) {
      fluent.withAddPage(instance.getAddPage());
      fluent.withBrand(instance.getBrand());
      fluent.withCustomLogoFile(instance.getCustomLogoFile());
      fluent.withCustomProductName(instance.getCustomProductName());
      fluent.withDeveloperCatalog(instance.getDeveloperCatalog());
      fluent.withDocumentationBaseURL(instance.getDocumentationBaseURL());
      fluent.withPerspectives(instance.getPerspectives());
      fluent.withProjectAccess(instance.getProjectAccess());
      fluent.withQuickStarts(instance.getQuickStarts());
      fluent.withAddPage(instance.getAddPage());
      fluent.withBrand(instance.getBrand());
      fluent.withCustomLogoFile(instance.getCustomLogoFile());
      fluent.withCustomProductName(instance.getCustomProductName());
      fluent.withDeveloperCatalog(instance.getDeveloperCatalog());
      fluent.withDocumentationBaseURL(instance.getDocumentationBaseURL());
      fluent.withPerspectives(instance.getPerspectives());
      fluent.withProjectAccess(instance.getProjectAccess());
      fluent.withQuickStarts(instance.getQuickStarts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleCustomizationBuilder(ConsoleCustomization instance) {
    this(instance,false);
  }
  public ConsoleCustomizationBuilder(ConsoleCustomization instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsoleCustomization());

    if (instance != null) {
      this.withAddPage(instance.getAddPage());
      this.withBrand(instance.getBrand());
      this.withCustomLogoFile(instance.getCustomLogoFile());
      this.withCustomProductName(instance.getCustomProductName());
      this.withDeveloperCatalog(instance.getDeveloperCatalog());
      this.withDocumentationBaseURL(instance.getDocumentationBaseURL());
      this.withPerspectives(instance.getPerspectives());
      this.withProjectAccess(instance.getProjectAccess());
      this.withQuickStarts(instance.getQuickStarts());
      this.withAddPage(instance.getAddPage());
      this.withBrand(instance.getBrand());
      this.withCustomLogoFile(instance.getCustomLogoFile());
      this.withCustomProductName(instance.getCustomProductName());
      this.withDeveloperCatalog(instance.getDeveloperCatalog());
      this.withDocumentationBaseURL(instance.getDocumentationBaseURL());
      this.withPerspectives(instance.getPerspectives());
      this.withProjectAccess(instance.getProjectAccess());
      this.withQuickStarts(instance.getQuickStarts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleCustomizationFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleCustomization build() {
    ConsoleCustomization buildable = new ConsoleCustomization(fluent.buildAddPage(),fluent.getBrand(),fluent.getCustomLogoFile(),fluent.getCustomProductName(),fluent.buildDeveloperCatalog(),fluent.getDocumentationBaseURL(),fluent.buildPerspectives(),fluent.buildProjectAccess(),fluent.buildQuickStarts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}