package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSNodePlacementBuilder extends DNSNodePlacementFluent<DNSNodePlacementBuilder> implements VisitableBuilder<DNSNodePlacement,DNSNodePlacementBuilder>{
  public DNSNodePlacementBuilder() {
    this(false);
  }
  public DNSNodePlacementBuilder(Boolean validationEnabled) {
    this(new DNSNodePlacement(), validationEnabled);
  }
  public DNSNodePlacementBuilder(DNSNodePlacementFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSNodePlacementBuilder(DNSNodePlacementFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSNodePlacement(), validationEnabled);
  }
  public DNSNodePlacementBuilder(DNSNodePlacementFluent<?> fluent,DNSNodePlacement instance) {
    this(fluent, instance, false);
  }
  public DNSNodePlacementBuilder(DNSNodePlacementFluent<?> fluent,DNSNodePlacement instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSNodePlacement());

    if (instance != null) {
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withTolerations(instance.getTolerations());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withTolerations(instance.getTolerations());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSNodePlacementBuilder(DNSNodePlacement instance) {
    this(instance,false);
  }
  public DNSNodePlacementBuilder(DNSNodePlacement instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSNodePlacement());

    if (instance != null) {
      this.withNodeSelector(instance.getNodeSelector());
      this.withTolerations(instance.getTolerations());
      this.withNodeSelector(instance.getNodeSelector());
      this.withTolerations(instance.getTolerations());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSNodePlacementFluent<?> fluent;
  Boolean validationEnabled;
  public DNSNodePlacement build() {
    DNSNodePlacement buildable = new DNSNodePlacement(fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}