package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSOverTLSConfigBuilder extends DNSOverTLSConfigFluent<DNSOverTLSConfigBuilder> implements VisitableBuilder<DNSOverTLSConfig,DNSOverTLSConfigBuilder>{
  public DNSOverTLSConfigBuilder() {
    this(false);
  }
  public DNSOverTLSConfigBuilder(Boolean validationEnabled) {
    this(new DNSOverTLSConfig(), validationEnabled);
  }
  public DNSOverTLSConfigBuilder(DNSOverTLSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSOverTLSConfigBuilder(DNSOverTLSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSOverTLSConfig(), validationEnabled);
  }
  public DNSOverTLSConfigBuilder(DNSOverTLSConfigFluent<?> fluent,DNSOverTLSConfig instance) {
    this(fluent, instance, false);
  }
  public DNSOverTLSConfigBuilder(DNSOverTLSConfigFluent<?> fluent,DNSOverTLSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSOverTLSConfig());

    if (instance != null) {
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withServerName(instance.getServerName());
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withServerName(instance.getServerName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSOverTLSConfigBuilder(DNSOverTLSConfig instance) {
    this(instance,false);
  }
  public DNSOverTLSConfigBuilder(DNSOverTLSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSOverTLSConfig());

    if (instance != null) {
      this.withCaBundle(instance.getCaBundle());
      this.withServerName(instance.getServerName());
      this.withCaBundle(instance.getCaBundle());
      this.withServerName(instance.getServerName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSOverTLSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public DNSOverTLSConfig build() {
    DNSOverTLSConfig buildable = new DNSOverTLSConfig(fluent.getCaBundle(),fluent.getServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}