package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSRecordSpecBuilder extends DNSRecordSpecFluent<DNSRecordSpecBuilder> implements VisitableBuilder<DNSRecordSpec,DNSRecordSpecBuilder>{
  public DNSRecordSpecBuilder() {
    this(false);
  }
  public DNSRecordSpecBuilder(Boolean validationEnabled) {
    this(new DNSRecordSpec(), validationEnabled);
  }
  public DNSRecordSpecBuilder(DNSRecordSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSRecordSpecBuilder(DNSRecordSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSRecordSpec(), validationEnabled);
  }
  public DNSRecordSpecBuilder(DNSRecordSpecFluent<?> fluent,DNSRecordSpec instance) {
    this(fluent, instance, false);
  }
  public DNSRecordSpecBuilder(DNSRecordSpecFluent<?> fluent,DNSRecordSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSRecordSpec());

    if (instance != null) {
      fluent.withDnsManagementPolicy(instance.getDnsManagementPolicy());
      fluent.withDnsName(instance.getDnsName());
      fluent.withRecordTTL(instance.getRecordTTL());
      fluent.withRecordType(instance.getRecordType());
      fluent.withTargets(instance.getTargets());
      fluent.withDnsManagementPolicy(instance.getDnsManagementPolicy());
      fluent.withDnsName(instance.getDnsName());
      fluent.withRecordTTL(instance.getRecordTTL());
      fluent.withRecordType(instance.getRecordType());
      fluent.withTargets(instance.getTargets());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSRecordSpecBuilder(DNSRecordSpec instance) {
    this(instance,false);
  }
  public DNSRecordSpecBuilder(DNSRecordSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSRecordSpec());

    if (instance != null) {
      this.withDnsManagementPolicy(instance.getDnsManagementPolicy());
      this.withDnsName(instance.getDnsName());
      this.withRecordTTL(instance.getRecordTTL());
      this.withRecordType(instance.getRecordType());
      this.withTargets(instance.getTargets());
      this.withDnsManagementPolicy(instance.getDnsManagementPolicy());
      this.withDnsName(instance.getDnsName());
      this.withRecordTTL(instance.getRecordTTL());
      this.withRecordType(instance.getRecordType());
      this.withTargets(instance.getTargets());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSRecordSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DNSRecordSpec build() {
    DNSRecordSpec buildable = new DNSRecordSpec(fluent.getDnsManagementPolicy(),fluent.getDnsName(),fluent.getRecordTTL(),fluent.getRecordType(),fluent.getTargets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}