package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSRecordSpecFluent<A extends DNSRecordSpecFluent<A>> extends BaseFluent<A>{
  public DNSRecordSpecFluent() {
  }
  public DNSRecordSpecFluent(DNSRecordSpec instance) {
    instance = (instance != null ? instance : new DNSRecordSpec());

    if (instance != null) {
      this.withDnsManagementPolicy(instance.getDnsManagementPolicy());
      this.withDnsName(instance.getDnsName());
      this.withRecordTTL(instance.getRecordTTL());
      this.withRecordType(instance.getRecordType());
      this.withTargets(instance.getTargets());
      this.withDnsManagementPolicy(instance.getDnsManagementPolicy());
      this.withDnsName(instance.getDnsName());
      this.withRecordTTL(instance.getRecordTTL());
      this.withRecordType(instance.getRecordType());
      this.withTargets(instance.getTargets());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String dnsManagementPolicy;
  private String dnsName;
  private Long recordTTL;
  private String recordType;
  private List<String> targets = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getDnsManagementPolicy() {
    return this.dnsManagementPolicy;
  }
  public A withDnsManagementPolicy(String dnsManagementPolicy) {
    this.dnsManagementPolicy=dnsManagementPolicy; return (A) this;
  }
  public boolean hasDnsManagementPolicy() {
    return this.dnsManagementPolicy != null;
  }
  public String getDnsName() {
    return this.dnsName;
  }
  public A withDnsName(String dnsName) {
    this.dnsName=dnsName; return (A) this;
  }
  public boolean hasDnsName() {
    return this.dnsName != null;
  }
  public Long getRecordTTL() {
    return this.recordTTL;
  }
  public A withRecordTTL(Long recordTTL) {
    this.recordTTL=recordTTL; return (A) this;
  }
  public boolean hasRecordTTL() {
    return this.recordTTL != null;
  }
  public String getRecordType() {
    return this.recordType;
  }
  public A withRecordType(String recordType) {
    this.recordType=recordType; return (A) this;
  }
  public boolean hasRecordType() {
    return this.recordType != null;
  }
  public A addToTargets(int index,String item) {
    if (this.targets == null) {this.targets = new ArrayList<String>();}
    this.targets.add(index, item);
    return (A)this;
  }
  public A setToTargets(int index,String item) {
    if (this.targets == null) {this.targets = new ArrayList<String>();}
    this.targets.set(index, item); return (A)this;
  }
  public A addToTargets(java.lang.String... items) {
    if (this.targets == null) {this.targets = new ArrayList<String>();}
    for (String item : items) {this.targets.add(item);} return (A)this;
  }
  public A addAllToTargets(Collection<String> items) {
    if (this.targets == null) {this.targets = new ArrayList<String>();}
    for (String item : items) {this.targets.add(item);} return (A)this;
  }
  public A removeFromTargets(java.lang.String... items) {
    if (this.targets == null) return (A)this;
    for (String item : items) { this.targets.remove(item);} return (A)this;
  }
  public A removeAllFromTargets(Collection<String> items) {
    if (this.targets == null) return (A)this;
    for (String item : items) { this.targets.remove(item);} return (A)this;
  }
  public List<String> getTargets() {
    return this.targets;
  }
  public String getTarget(int index) {
    return this.targets.get(index);
  }
  public String getFirstTarget() {
    return this.targets.get(0);
  }
  public String getLastTarget() {
    return this.targets.get(targets.size() - 1);
  }
  public String getMatchingTarget(Predicate<String> predicate) {
    for (String item: targets) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingTarget(Predicate<String> predicate) {
    for (String item: targets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTargets(List<String> targets) {
    if (targets != null) {this.targets = new ArrayList(); for (String item : targets){this.addToTargets(item);}} else { this.targets = null;} return (A) this;
  }
  public A withTargets(java.lang.String... targets) {
    if (this.targets != null) {this.targets.clear(); _visitables.remove("targets"); }
    if (targets != null) {for (String item :targets){ this.addToTargets(item);}} return (A) this;
  }
  public boolean hasTargets() {
    return targets != null && !targets.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSRecordSpecFluent that = (DNSRecordSpecFluent) o;
    if (!java.util.Objects.equals(dnsManagementPolicy, that.dnsManagementPolicy)) return false;

    if (!java.util.Objects.equals(dnsName, that.dnsName)) return false;

    if (!java.util.Objects.equals(recordTTL, that.recordTTL)) return false;

    if (!java.util.Objects.equals(recordType, that.recordType)) return false;

    if (!java.util.Objects.equals(targets, that.targets)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(dnsManagementPolicy,  dnsName,  recordTTL,  recordType,  targets,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dnsManagementPolicy != null) { sb.append("dnsManagementPolicy:"); sb.append(dnsManagementPolicy + ","); }
    if (dnsName != null) { sb.append("dnsName:"); sb.append(dnsName + ","); }
    if (recordTTL != null) { sb.append("recordTTL:"); sb.append(recordTTL + ","); }
    if (recordType != null) { sb.append("recordType:"); sb.append(recordType + ","); }
    if (targets != null && !targets.isEmpty()) { sb.append("targets:"); sb.append(targets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}