package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSRecordStatusBuilder extends DNSRecordStatusFluent<DNSRecordStatusBuilder> implements VisitableBuilder<DNSRecordStatus,DNSRecordStatusBuilder>{
  public DNSRecordStatusBuilder() {
    this(false);
  }
  public DNSRecordStatusBuilder(Boolean validationEnabled) {
    this(new DNSRecordStatus(), validationEnabled);
  }
  public DNSRecordStatusBuilder(DNSRecordStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSRecordStatusBuilder(DNSRecordStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSRecordStatus(), validationEnabled);
  }
  public DNSRecordStatusBuilder(DNSRecordStatusFluent<?> fluent,DNSRecordStatus instance) {
    this(fluent, instance, false);
  }
  public DNSRecordStatusBuilder(DNSRecordStatusFluent<?> fluent,DNSRecordStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSRecordStatus());

    if (instance != null) {
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withZones(instance.getZones());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withZones(instance.getZones());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSRecordStatusBuilder(DNSRecordStatus instance) {
    this(instance,false);
  }
  public DNSRecordStatusBuilder(DNSRecordStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSRecordStatus());

    if (instance != null) {
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withZones(instance.getZones());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSRecordStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DNSRecordStatus build() {
    DNSRecordStatus buildable = new DNSRecordStatus(fluent.getObservedGeneration(),fluent.buildZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}