package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DefaultNetworkDefinitionBuilder extends DefaultNetworkDefinitionFluent<DefaultNetworkDefinitionBuilder> implements VisitableBuilder<DefaultNetworkDefinition,DefaultNetworkDefinitionBuilder>{
  public DefaultNetworkDefinitionBuilder() {
    this(false);
  }
  public DefaultNetworkDefinitionBuilder(Boolean validationEnabled) {
    this(new DefaultNetworkDefinition(), validationEnabled);
  }
  public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent) {
    this(fluent, false);
  }
  public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DefaultNetworkDefinition(), validationEnabled);
  }
  public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent,DefaultNetworkDefinition instance) {
    this(fluent, instance, false);
  }
  public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent,DefaultNetworkDefinition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DefaultNetworkDefinition());

    if (instance != null) {
      fluent.withKuryrConfig(instance.getKuryrConfig());
      fluent.withOpenshiftSDNConfig(instance.getOpenshiftSDNConfig());
      fluent.withOvnKubernetesConfig(instance.getOvnKubernetesConfig());
      fluent.withType(instance.getType());
      fluent.withKuryrConfig(instance.getKuryrConfig());
      fluent.withOpenshiftSDNConfig(instance.getOpenshiftSDNConfig());
      fluent.withOvnKubernetesConfig(instance.getOvnKubernetesConfig());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinition instance) {
    this(instance,false);
  }
  public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DefaultNetworkDefinition());

    if (instance != null) {
      this.withKuryrConfig(instance.getKuryrConfig());
      this.withOpenshiftSDNConfig(instance.getOpenshiftSDNConfig());
      this.withOvnKubernetesConfig(instance.getOvnKubernetesConfig());
      this.withType(instance.getType());
      this.withKuryrConfig(instance.getKuryrConfig());
      this.withOpenshiftSDNConfig(instance.getOpenshiftSDNConfig());
      this.withOvnKubernetesConfig(instance.getOvnKubernetesConfig());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DefaultNetworkDefinitionFluent<?> fluent;
  Boolean validationEnabled;
  public DefaultNetworkDefinition build() {
    DefaultNetworkDefinition buildable = new DefaultNetworkDefinition(fluent.buildKuryrConfig(),fluent.buildOpenshiftSDNConfig(),fluent.buildOvnKubernetesConfig(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}