package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeveloperConsoleCatalogTypesBuilder extends DeveloperConsoleCatalogTypesFluent<DeveloperConsoleCatalogTypesBuilder> implements VisitableBuilder<DeveloperConsoleCatalogTypes,DeveloperConsoleCatalogTypesBuilder>{
  public DeveloperConsoleCatalogTypesBuilder() {
    this(false);
  }
  public DeveloperConsoleCatalogTypesBuilder(Boolean validationEnabled) {
    this(new DeveloperConsoleCatalogTypes(), validationEnabled);
  }
  public DeveloperConsoleCatalogTypesBuilder(DeveloperConsoleCatalogTypesFluent<?> fluent) {
    this(fluent, false);
  }
  public DeveloperConsoleCatalogTypesBuilder(DeveloperConsoleCatalogTypesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeveloperConsoleCatalogTypes(), validationEnabled);
  }
  public DeveloperConsoleCatalogTypesBuilder(DeveloperConsoleCatalogTypesFluent<?> fluent,DeveloperConsoleCatalogTypes instance) {
    this(fluent, instance, false);
  }
  public DeveloperConsoleCatalogTypesBuilder(DeveloperConsoleCatalogTypesFluent<?> fluent,DeveloperConsoleCatalogTypes instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DeveloperConsoleCatalogTypes());

    if (instance != null) {
      fluent.withDisabled(instance.getDisabled());
      fluent.withEnabled(instance.getEnabled());
      fluent.withState(instance.getState());
      fluent.withDisabled(instance.getDisabled());
      fluent.withEnabled(instance.getEnabled());
      fluent.withState(instance.getState());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeveloperConsoleCatalogTypesBuilder(DeveloperConsoleCatalogTypes instance) {
    this(instance,false);
  }
  public DeveloperConsoleCatalogTypesBuilder(DeveloperConsoleCatalogTypes instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DeveloperConsoleCatalogTypes());

    if (instance != null) {
      this.withDisabled(instance.getDisabled());
      this.withEnabled(instance.getEnabled());
      this.withState(instance.getState());
      this.withDisabled(instance.getDisabled());
      this.withEnabled(instance.getEnabled());
      this.withState(instance.getState());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeveloperConsoleCatalogTypesFluent<?> fluent;
  Boolean validationEnabled;
  public DeveloperConsoleCatalogTypes build() {
    DeveloperConsoleCatalogTypes buildable = new DeveloperConsoleCatalogTypes(fluent.getDisabled(),fluent.getEnabled(),fluent.getState());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}