package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EtcdBuilder extends EtcdFluent<EtcdBuilder> implements VisitableBuilder<Etcd,EtcdBuilder>{
  public EtcdBuilder() {
    this(false);
  }
  public EtcdBuilder(Boolean validationEnabled) {
    this(new Etcd(), validationEnabled);
  }
  public EtcdBuilder(EtcdFluent<?> fluent) {
    this(fluent, false);
  }
  public EtcdBuilder(EtcdFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Etcd(), validationEnabled);
  }
  public EtcdBuilder(EtcdFluent<?> fluent,Etcd instance) {
    this(fluent, instance, false);
  }
  public EtcdBuilder(EtcdFluent<?> fluent,Etcd instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Etcd());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EtcdBuilder(Etcd instance) {
    this(instance,false);
  }
  public EtcdBuilder(Etcd instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Etcd());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EtcdFluent<?> fluent;
  Boolean validationEnabled;
  public Etcd build() {
    Etcd buildable = new Etcd(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}