package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeaturesMigrationBuilder extends FeaturesMigrationFluent<FeaturesMigrationBuilder> implements VisitableBuilder<FeaturesMigration,FeaturesMigrationBuilder>{
  public FeaturesMigrationBuilder() {
    this(false);
  }
  public FeaturesMigrationBuilder(Boolean validationEnabled) {
    this(new FeaturesMigration(), validationEnabled);
  }
  public FeaturesMigrationBuilder(FeaturesMigrationFluent<?> fluent) {
    this(fluent, false);
  }
  public FeaturesMigrationBuilder(FeaturesMigrationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeaturesMigration(), validationEnabled);
  }
  public FeaturesMigrationBuilder(FeaturesMigrationFluent<?> fluent,FeaturesMigration instance) {
    this(fluent, instance, false);
  }
  public FeaturesMigrationBuilder(FeaturesMigrationFluent<?> fluent,FeaturesMigration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FeaturesMigration());

    if (instance != null) {
      fluent.withEgressFirewall(instance.getEgressFirewall());
      fluent.withEgressIP(instance.getEgressIP());
      fluent.withMulticast(instance.getMulticast());
      fluent.withEgressFirewall(instance.getEgressFirewall());
      fluent.withEgressIP(instance.getEgressIP());
      fluent.withMulticast(instance.getMulticast());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FeaturesMigrationBuilder(FeaturesMigration instance) {
    this(instance,false);
  }
  public FeaturesMigrationBuilder(FeaturesMigration instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FeaturesMigration());

    if (instance != null) {
      this.withEgressFirewall(instance.getEgressFirewall());
      this.withEgressIP(instance.getEgressIP());
      this.withMulticast(instance.getMulticast());
      this.withEgressFirewall(instance.getEgressFirewall());
      this.withEgressIP(instance.getEgressIP());
      this.withMulticast(instance.getMulticast());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FeaturesMigrationFluent<?> fluent;
  Boolean validationEnabled;
  public FeaturesMigration build() {
    FeaturesMigration buildable = new FeaturesMigration(fluent.getEgressFirewall(),fluent.getEgressIP(),fluent.getMulticast());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}