package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPKMSKeyReferenceBuilder extends GCPKMSKeyReferenceFluent<GCPKMSKeyReferenceBuilder> implements VisitableBuilder<GCPKMSKeyReference,GCPKMSKeyReferenceBuilder>{
  public GCPKMSKeyReferenceBuilder() {
    this(false);
  }
  public GCPKMSKeyReferenceBuilder(Boolean validationEnabled) {
    this(new GCPKMSKeyReference(), validationEnabled);
  }
  public GCPKMSKeyReferenceBuilder(GCPKMSKeyReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPKMSKeyReferenceBuilder(GCPKMSKeyReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPKMSKeyReference(), validationEnabled);
  }
  public GCPKMSKeyReferenceBuilder(GCPKMSKeyReferenceFluent<?> fluent,GCPKMSKeyReference instance) {
    this(fluent, instance, false);
  }
  public GCPKMSKeyReferenceBuilder(GCPKMSKeyReferenceFluent<?> fluent,GCPKMSKeyReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GCPKMSKeyReference());

    if (instance != null) {
      fluent.withKeyRing(instance.getKeyRing());
      fluent.withLocation(instance.getLocation());
      fluent.withName(instance.getName());
      fluent.withProjectID(instance.getProjectID());
      fluent.withKeyRing(instance.getKeyRing());
      fluent.withLocation(instance.getLocation());
      fluent.withName(instance.getName());
      fluent.withProjectID(instance.getProjectID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GCPKMSKeyReferenceBuilder(GCPKMSKeyReference instance) {
    this(instance,false);
  }
  public GCPKMSKeyReferenceBuilder(GCPKMSKeyReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GCPKMSKeyReference());

    if (instance != null) {
      this.withKeyRing(instance.getKeyRing());
      this.withLocation(instance.getLocation());
      this.withName(instance.getName());
      this.withProjectID(instance.getProjectID());
      this.withKeyRing(instance.getKeyRing());
      this.withLocation(instance.getLocation());
      this.withName(instance.getName());
      this.withProjectID(instance.getProjectID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GCPKMSKeyReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public GCPKMSKeyReference build() {
    GCPKMSKeyReference buildable = new GCPKMSKeyReference(fluent.getKeyRing(),fluent.getLocation(),fluent.getName(),fluent.getProjectID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}