package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostNetworkStrategyBuilder extends HostNetworkStrategyFluent<HostNetworkStrategyBuilder> implements VisitableBuilder<HostNetworkStrategy,HostNetworkStrategyBuilder>{
  public HostNetworkStrategyBuilder() {
    this(false);
  }
  public HostNetworkStrategyBuilder(Boolean validationEnabled) {
    this(new HostNetworkStrategy(), validationEnabled);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HostNetworkStrategy(), validationEnabled);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent,HostNetworkStrategy instance) {
    this(fluent, instance, false);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent,HostNetworkStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HostNetworkStrategy());

    if (instance != null) {
      fluent.withHttpPort(instance.getHttpPort());
      fluent.withHttpsPort(instance.getHttpsPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withStatsPort(instance.getStatsPort());
      fluent.withHttpPort(instance.getHttpPort());
      fluent.withHttpsPort(instance.getHttpsPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withStatsPort(instance.getStatsPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategy instance) {
    this(instance,false);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HostNetworkStrategy());

    if (instance != null) {
      this.withHttpPort(instance.getHttpPort());
      this.withHttpsPort(instance.getHttpsPort());
      this.withProtocol(instance.getProtocol());
      this.withStatsPort(instance.getStatsPort());
      this.withHttpPort(instance.getHttpPort());
      this.withHttpsPort(instance.getHttpsPort());
      this.withProtocol(instance.getProtocol());
      this.withStatsPort(instance.getStatsPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HostNetworkStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public HostNetworkStrategy build() {
    HostNetworkStrategy buildable = new HostNetworkStrategy(fluent.getHttpPort(),fluent.getHttpsPort(),fluent.getProtocol(),fluent.getStatsPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}